VERSION 5.00
Begin VB.Form DC_Customer 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Customer Shipments"
   ClientHeight    =   10575
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   10320
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   10575
   ScaleWidth      =   10320
   ShowInTaskbar   =   0   'False
   Begin VB.TextBox txt_palletes 
      Height          =   315
      Left            =   1605
      MaxLength       =   6
      TabIndex        =   78
      Tag             =   "Palletes"
      Top             =   3800
      Width           =   735
   End
   Begin Project1.ArmCheckView0 ckv_surcharges 
      Height          =   1320
      Left            =   6885
      TabIndex        =   76
      Top             =   2745
      Width           =   3330
      _ExtentX        =   5874
      _ExtentY        =   1720
   End
   Begin VB.CheckBox chk_isReturn 
      Caption         =   "#Is return"
      Height          =   255
      Left            =   3435
      TabIndex        =   75
      Tag             =   "chk_isReturn"
      Top             =   2850
      Width           =   1365
   End
   Begin VB.TextBox txt_RealQuantity 
      Height          =   288
      Left            =   6165
      MaxLength       =   6
      TabIndex        =   20
      Tag             =   "Quantity_loaded"
      Text            =   "25000"
      Top             =   3375
      Width           =   615
   End
   Begin VB.ComboBox cbo_postCode 
      Height          =   315
      ItemData        =   "CUSTOMER.frx":0000
      Left            =   8745
      List            =   "CUSTOMER.frx":0002
      TabIndex        =   12
      Tag             =   "Ship_To_Zip_Code"
      Text            =   "cbo_postCode"
      Top             =   1410
      Width           =   1455
   End
   Begin VB.CheckBox chk_manualPrice 
      Alignment       =   1  'Right Justify
      Caption         =   "#Manual country/zip"
      Height          =   255
      Left            =   8055
      TabIndex        =   5
      Top             =   570
      Width           =   2070
   End
   Begin VB.ComboBox cbo_delivery 
      Height          =   315
      ItemData        =   "CUSTOMER.frx":0004
      Left            =   5160
      List            =   "CUSTOMER.frx":0006
      TabIndex        =   16
      Tag             =   "Delivery_Number"
      Top             =   2295
      Width           =   1875
   End
   Begin VB.TextBox txt_totalQty 
      Height          =   288
      Left            =   5475
      TabIndex        =   21
      TabStop         =   0   'False
      Tag             =   "Total_qty"
      Top             =   4230
      Width           =   615
   End
   Begin VB.CommandButton btn_OK2 
      Height          =   615
      Left            =   6540
      Style           =   1  'Graphical
      TabIndex        =   37
      Top             =   9780
      Width           =   615
   End
   Begin VB.TextBox txt_tranOrder 
      ForeColor       =   &H00000000&
      Height          =   288
      Left            =   6075
      TabIndex        =   4
      Tag             =   "TRANS_Order"
      Top             =   495
      Width           =   1635
   End
   Begin VB.TextBox txt_paidByCustomer 
      Height          =   288
      Left            =   7980
      MaxLength       =   6
      TabIndex        =   23
      Tag             =   "CUST_Freight_Cost"
      Top             =   4275
      Width           =   600
   End
   Begin VB.CommandButton btn_SAP_SearchData 
      Caption         =   ">"
      Height          =   285
      Left            =   3165
      TabIndex        =   9
      Top             =   2310
      Width           =   285
   End
   Begin Project1.ArmCombobox cbo_country 
      Height          =   345
      Left            =   5685
      TabIndex        =   11
      Tag             =   "Ship_To_CT_Code"
      Top             =   1395
      Width           =   1980
      _ExtentX        =   3493
      _ExtentY        =   609
   End
   Begin VB.Frame Fr_Actual 
      Caption         =   "Actual"
      Height          =   3165
      Left            =   165
      TabIndex        =   58
      Top             =   6480
      Width           =   9975
      Begin VB.TextBox txt_totalCost 
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   330
         Left            =   5745
         Locked          =   -1  'True
         TabIndex        =   71
         TabStop         =   0   'False
         Tag             =   "Total_cost"
         Top             =   2730
         Width           =   1140
      End
      Begin VB.TextBox txt_ArrivalTime 
         Height          =   288
         Left            =   2160
         MaxLength       =   5
         TabIndex        =   31
         Tag             =   "Load_Arrival_Time"
         Top             =   330
         Width           =   2052
      End
      Begin VB.TextBox txt_LoadStartTime 
         Height          =   288
         Left            =   2160
         MaxLength       =   5
         TabIndex        =   32
         Tag             =   "Load_Starting_Time"
         Top             =   720
         Width           =   2052
      End
      Begin VB.TextBox txt_LoadBy 
         Height          =   288
         Left            =   1440
         MaxLength       =   15
         TabIndex        =   33
         Tag             =   "Load_By"
         Top             =   1080
         Width           =   2772
      End
      Begin VB.TextBox txt_TrailerNb 
         Height          =   288
         Left            =   2040
         MaxLength       =   15
         TabIndex        =   34
         Tag             =   "Trailer_Number"
         Top             =   1440
         Width           =   2172
      End
      Begin VB.TextBox txt_LoadEndTime 
         Height          =   288
         Left            =   2040
         MaxLength       =   5
         TabIndex        =   35
         Tag             =   "Load_Ending_Time"
         Top             =   1800
         Width           =   2172
      End
      Begin Project1.DCCost DCCost1 
         Height          =   2460
         Left            =   4320
         TabIndex        =   36
         Top             =   240
         Width           =   5535
         _ExtentX        =   9763
         _ExtentY        =   4339
      End
      Begin VB.Label lbl_totalCost 
         Caption         =   "Total cost"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   4350
         TabIndex        =   70
         Tag             =   "Total_cost"
         Top             =   2790
         Width           =   1335
      End
      Begin VB.Label lbl_ArrivalTime 
         Caption         =   "Arrival time"
         Height          =   255
         Left            =   120
         TabIndex        =   63
         Top             =   330
         Width           =   2055
      End
      Begin VB.Label lbl_LoadStartTime 
         Caption         =   "Load starting time"
         Height          =   255
         Left            =   120
         TabIndex        =   62
         Top             =   720
         Width           =   2055
      End
      Begin VB.Label lbl_LoadBy 
         Caption         =   "Load by"
         Height          =   255
         Left            =   120
         TabIndex        =   61
         Top             =   1080
         Width           =   1935
      End
      Begin VB.Label lbl_TrailerNb 
         Caption         =   "Trailer n"
         Height          =   255
         Left            =   120
         TabIndex        =   60
         Top             =   1440
         Width           =   2175
      End
      Begin VB.Label lbl_LoadEndTime 
         Caption         =   "Load ending time"
         Height          =   255
         Left            =   120
         TabIndex        =   59
         Top             =   1800
         Width           =   2175
      End
   End
   Begin VB.Frame Fr_Schedule 
      Caption         =   "Schedule"
      Height          =   1095
      Left            =   165
      TabIndex        =   53
      Top             =   5295
      Width           =   9975
      Begin VB.TextBox txt_HaulierBookNb 
         Height          =   288
         Left            =   2160
         MaxLength       =   15
         TabIndex        =   26
         Tag             =   "Haulier_Booking_Number"
         Top             =   360
         Width           =   2052
      End
      Begin VB.TextBox txt_LoadPlanStartTime 
         Height          =   288
         Left            =   2160
         MaxLength       =   5
         TabIndex        =   29
         Tag             =   "Load_Planned_Starting_Time"
         Top             =   720
         Width           =   2052
      End
      Begin VB.TextBox txt_LoadPlanEndTime 
         Height          =   288
         Left            =   6960
         MaxLength       =   5
         TabIndex        =   30
         Tag             =   "Load_Planned_Ending_Time"
         Top             =   720
         Width           =   2172
      End
      Begin VB.OptionButton Opt_Yes 
         Caption         =   "Yes"
         Height          =   192
         Left            =   6960
         TabIndex        =   27
         Top             =   360
         Width           =   852
      End
      Begin VB.OptionButton Opt_No 
         Caption         =   "No"
         Height          =   192
         Left            =   7860
         TabIndex        =   28
         Top             =   360
         Value           =   -1  'True
         Width           =   972
      End
      Begin VB.Label lbl_HaulierBookNb 
         Caption         =   "Haulier bookin n"
         Height          =   255
         Left            =   120
         TabIndex        =   57
         Top             =   360
         Width           =   2055
      End
      Begin VB.Label lbl_LoadPlanStartTime 
         Caption         =   "Load planned starting time"
         Height          =   255
         Left            =   120
         TabIndex        =   56
         Top             =   720
         Width           =   2055
      End
      Begin VB.Label lbl_LoadPlanEndTime 
         Caption         =   "Load planned ending time"
         Height          =   255
         Left            =   4800
         TabIndex        =   55
         Top             =   720
         Width           =   2175
      End
      Begin VB.Label lbl_StandTrailers 
         Caption         =   "Stand trailers"
         Height          =   255
         Left            =   4800
         TabIndex        =   54
         Top             =   360
         Width           =   1335
      End
   End
   Begin VB.CommandButton spp_save 
      Default         =   -1  'True
      Height          =   615
      Left            =   8865
      Style           =   1  'Graphical
      TabIndex        =   38
      Top             =   9780
      Width           =   615
   End
   Begin VB.CommandButton ssp_quit 
      Cancel          =   -1  'True
      CausesValidation=   0   'False
      Height          =   615
      Left            =   9555
      Style           =   1  'Graphical
      TabIndex        =   39
      Top             =   9780
      Width           =   615
   End
   Begin VB.CommandButton SSDeliveryDate 
      Height          =   276
      Left            =   2910
      Style           =   1  'Graphical
      TabIndex        =   18
      Top             =   2850
      Width           =   252
   End
   Begin VB.CommandButton SSShipDate 
      Height          =   276
      Left            =   3270
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   525
      Width           =   252
   End
   Begin VB.TextBox txt_CustName 
      Height          =   288
      Left            =   1590
      MaxLength       =   80
      TabIndex        =   10
      Tag             =   "CUSTN1"
      Text            =   "Text1"
      Top             =   1410
      Width           =   3120
   End
   Begin VB.TextBox txt_ShipFromDC 
      Height          =   288
      Left            =   1560
      Locked          =   -1  'True
      MaxLength       =   30
      TabIndex        =   0
      Tag             =   "DC_Name"
      Text            =   "Pontarlier"
      Top             =   120
      Width           =   2772
   End
   Begin VB.TextBox txt_COSContact 
      Height          =   288
      Left            =   1605
      MaxLength       =   15
      TabIndex        =   22
      Tag             =   "COS_Contact"
      Top             =   4230
      Width           =   2655
   End
   Begin VB.TextBox txt_QuantityWeight 
      Height          =   288
      Left            =   1605
      MaxLength       =   6
      TabIndex        =   14
      Tag             =   "Quantity"
      Top             =   3375
      Width           =   615
   End
   Begin VB.TextBox txt_ShipAdd 
      Height          =   288
      Left            =   1590
      MaxLength       =   80
      TabIndex        =   13
      Tag             =   "Ship_To_Address"
      Top             =   1845
      Width           =   8600
   End
   Begin VB.TextBox txt_ShipDate 
      ForeColor       =   &H00000000&
      Height          =   288
      Left            =   1560
      Locked          =   -1  'True
      TabIndex        =   3
      TabStop         =   0   'False
      Tag             =   "TRANS_Date"
      Top             =   480
      Width           =   1635
   End
   Begin VB.TextBox txt_RSRequire 
      CausesValidation=   0   'False
      Height          =   525
      Left            =   1605
      MaxLength       =   240
      MultiLine       =   -1  'True
      TabIndex        =   25
      Tag             =   "Remark"
      Top             =   4725
      Width           =   8600
   End
   Begin VB.TextBox txt_DeliveryDate 
      ForeColor       =   &H00000000&
      Height          =   288
      Left            =   1590
      Locked          =   -1  'True
      TabIndex        =   19
      TabStop         =   0   'False
      Tag             =   "Delivery_Date"
      Top             =   2850
      Width           =   1212
   End
   Begin VB.TextBox txt_CLSShipNb 
      Height          =   288
      Left            =   8655
      MaxLength       =   20
      TabIndex        =   17
      Tag             =   "Shipment_Number"
      Top             =   2295
      Width           =   1530
   End
   Begin VB.TextBox txt_CLSOrderNb 
      Height          =   288
      Left            =   1590
      MaxLength       =   20
      TabIndex        =   8
      Tag             =   "Order_Number"
      Top             =   2295
      Width           =   1530
   End
   Begin Project1.ArmCombobox cbo_masterTran 
      Height          =   345
      Left            =   6075
      TabIndex        =   1
      Tag             =   "Master_TRANS_Code"
      Top             =   90
      Width           =   4050
      _ExtentX        =   7144
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_currency 
      Height          =   345
      Left            =   8700
      TabIndex        =   24
      Tag             =   "CUST_FC_Currency"
      Top             =   4215
      Width           =   1500
      _ExtentX        =   2646
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_carrier 
      Height          =   345
      Left            =   1575
      TabIndex        =   6
      Tag             =   "CARRIER_Code"
      Top             =   900
      Width           =   3165
      _ExtentX        =   5583
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_Equipement 
      Height          =   345
      Left            =   6810
      TabIndex        =   7
      Tag             =   "EQ_Code"
      Top             =   885
      Width           =   3360
      _ExtentX        =   5927
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_UOM 
      Height          =   345
      Left            =   3165
      TabIndex        =   15
      Tag             =   "UOM_Code"
      Top             =   3345
      Width           =   1140
      _ExtentX        =   2011
      _ExtentY        =   609
   End
   Begin VB.Label lbl_pallets 
      Caption         =   "Pallets"
      Height          =   255
      Left            =   150
      TabIndex        =   77
      Top             =   3840
      Width           =   1335
   End
   Begin VB.Label lbl_surcharges 
      Caption         =   "Additional surcharge"
      Height          =   255
      Left            =   5115
      TabIndex        =   74
      Top             =   2760
      Width           =   1725
   End
   Begin VB.Label lbl_RealQuantity 
      Caption         =   "Real Quantity loaded"
      Height          =   255
      Left            =   4425
      TabIndex        =   73
      Top             =   3405
      Width           =   1650
   End
   Begin VB.Label lbl_totalQty 
      Caption         =   "Total"
      Height          =   255
      Left            =   4395
      TabIndex        =   72
      Top             =   4260
      Width           =   945
   End
   Begin VB.Label lbl_transactionOrder 
      Caption         =   "Transaction order"
      Height          =   255
      Left            =   4515
      TabIndex        =   69
      Top             =   495
      Width           =   1545
   End
   Begin VB.Label lbl_paidByCustomer 
      Caption         =   "Customer Freight cost"
      Height          =   255
      Left            =   6210
      TabIndex        =   68
      Top             =   4290
      Width           =   1695
   End
   Begin VB.Label lbl_masterTran 
      Caption         =   "Master tran."
      Height          =   255
      Left            =   4890
      TabIndex        =   67
      Top             =   120
      Width           =   1155
   End
   Begin VB.Label lbl_CLSDeliveryNb 
      Caption         =   "CLS Delivery  n"
      Height          =   255
      Left            =   3690
      TabIndex        =   66
      Top             =   2340
      Width           =   1455
   End
   Begin VB.Label lbl_postCode 
      Caption         =   "Post Code"
      Height          =   255
      Left            =   7770
      TabIndex        =   65
      Top             =   1440
      Width           =   885
   End
   Begin VB.Label lbl_country 
      Caption         =   "Country"
      Height          =   255
      Left            =   4800
      TabIndex        =   64
      Top             =   1440
      Width           =   930
   End
   Begin VB.Label lbl_UOM 
      Alignment       =   1  'Right Justify
      Caption         =   "UOM"
      Height          =   255
      Left            =   2250
      TabIndex        =   52
      Top             =   3405
      Width           =   765
   End
   Begin VB.Label lbl_COSContact 
      Caption         =   "COS Contact"
      Height          =   255
      Left            =   165
      TabIndex        =   51
      Top             =   4230
      Width           =   1395
   End
   Begin VB.Label lbl_QuantityWeight 
      Caption         =   "Quantity/Weight"
      Height          =   255
      Left            =   150
      TabIndex        =   50
      Top             =   3390
      Width           =   1335
   End
   Begin VB.Label lbl_ShipAdd 
      Caption         =   "Ship to address"
      Height          =   255
      Left            =   150
      TabIndex        =   49
      Top             =   1845
      Width           =   1455
   End
   Begin VB.Label lbl_CustName 
      Caption         =   "Customer name"
      Height          =   255
      Left            =   150
      TabIndex        =   48
      Top             =   1440
      Width           =   1455
   End
   Begin VB.Label lbl_RSRequire 
      Caption         =   "R/S requirements"
      Height          =   255
      Left            =   165
      TabIndex        =   47
      Top             =   4725
      Width           =   1455
   End
   Begin VB.Label lbl_DeliveryDate 
      Caption         =   "Delivery date"
      Height          =   255
      Left            =   150
      TabIndex        =   46
      Top             =   2850
      Width           =   1455
   End
   Begin VB.Label lbl_CLSShipNb 
      Caption         =   "CLS Shipment n"
      Height          =   255
      Left            =   7080
      TabIndex        =   45
      Top             =   2340
      Width           =   1410
   End
   Begin VB.Label lbl_CLSOrderNb 
      Caption         =   "CLS Order n"
      Height          =   255
      Left            =   150
      TabIndex        =   44
      Top             =   2340
      Width           =   1455
   End
   Begin VB.Label lbl_Equipement 
      Caption         =   "Equipement"
      Height          =   255
      Left            =   5010
      TabIndex        =   43
      Top             =   960
      Width           =   1695
   End
   Begin VB.Label lbl_CarrierCpy 
      Caption         =   "Carrier company"
      Height          =   255
      Left            =   135
      TabIndex        =   42
      Top             =   960
      Width           =   1455
   End
   Begin VB.Label lbl_ShipDate 
      Caption         =   "Shipping date"
      Height          =   255
      Left            =   120
      TabIndex        =   41
      Top             =   495
      Width           =   1455
   End
   Begin VB.Label lbl_ShipFromDC 
      Caption         =   "Ship from DC"
      Height          =   252
      Left            =   120
      TabIndex        =   40
      Top             =   120
      Width           =   1452
   End
End
Attribute VB_Name = "DC_Customer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'what is new
'2.6.9 : fixed bug to synchronize behaviour in add action when executed first time and next time(JN)
'2.9.5 : armsyscom support into the control
'2.9.5 : Price list support
'3.0.5 : Surcharges into pricelist support

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SCREEN_NAME As String = "DC_Customer"
Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""

Dim ms_MsgInfo As Variant

#If LIVE = 1 Then
    Dim mo_Sys As Object
    Dim mo_Db As Object
    Dim mo_sapXML As Object
    Dim mo_scriptObj As Object
#Else
    Dim mo_Sys As ARMSYSCOMLib.ArmSYS
    Dim mo_Db As ARMSYSCOMLib.ArmDb
    Dim mo_sapXML As MSXML2.DOMDocument
    Dim mo_scriptObj As MSScriptControl.ScriptControl       ' to calculate the price list formula
#End If


' screen constants for title
Private ms_Title As String
Private ms_titleA As String
Private ms_titleU As String
Private ms_titleD As String

Private ml_U_Code As Long
Private ms_LoginName As String
Private mb_Initialized As Boolean
Private ms_reconnectServer As String
Private ms_reconnectDB As String
Private ms_reconnectUser As String
Private ms_reconnectPassword As String
Private ms_reconnectApp As String
Private ms_Language_Code As String
Private mb_eventRunning As Boolean
Private mb_PL_STYLE_ENABLED As Boolean
Private ms_inTranName As String

Private ms_UrlWebService As String

Private ms_TableName As String
Private ms_DC_Code As String
Private ms_DC_Name As String
Private md_shippingDay As Date

Dim ml_d As Long
Dim ml_prevMasterTran As Long
Dim md_manualCost As Double
Dim mb_synchLoadedQty As Boolean
Dim ml_iConcurrency As Long

Const QTY_FOR_TRANSPORT As Boolean = True
Const QTY_FOR_COST As Boolean = False


Private Enum SURCHARGE_COLS
    DCS_Price = 1
    DCPLL_Code = 2
    UOM_Code = 3
    DCS_Default = 4
    DCS_Formula = 5
    DCS_quantity = 6
End Enum

Private Type tDCSurcharge_cost
    DCS_Code As String
    DCS_quantity As Double
    DCS_Price As Double
    SurchargeFormula As String
End Type

Private Type tDCTransport_cost
    TRANS_Code As Long
    UOM_Code As String
    Quantity As Double
    Quantity_loaded As Double
'    DCS_quantity As Double
    DCPL_Code As Long
    DCPLLI_code As Long
    DCPLLI_Price As Double
    DCPLLI_CURR_Code As String
'    DCS_Price As Double
    Manual_Cost As Double
    Surcharge_Cost As Double
    DCPLL_Full_Truck_Price As Double
    DCPLL_Full_Truck_Min As Double
    DCPLL_Full_Truck_Max As Double
    DCPLL_Trailer_min As Double
  
    PriceFormula As String
    FullTruckPriceFormula As String
'    SurchargeFormula As String
    IsReturn    As Boolean
    
    SurchargeInfo() As tDCSurcharge_cost
End Type

Dim moa_DCTransport_cost() As tDCTransport_cost

Public Event RowAdded(ByVal av_Data As Variant)
Public Event RowUpdated(ByVal av_Data As Variant)
Public Event RowDeleted(ByVal av_Key As Variant)

Public Sub SetReconnectParams(ByVal as_Server As String, ByVal as_Db As String, ByVal as_User As String, ByVal as_Password As String, ByVal as_App As String)
On Error GoTo ErrHandler
    ms_reconnectServer = as_Server
    ms_reconnectDB = as_Db
    ms_reconnectUser = as_User
    ms_reconnectPassword = as_Password
    ms_reconnectApp = as_App
    Exit Sub
ErrHandler:
    Call ErrorMessage("SetReconnectParams")
End Sub

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Property Let Language_Code(AString As String)
On Error GoTo ErrHandler

  ms_Language_Code = AString
  Exit Property
ErrHandler:
  Call ErrorMessage("Language_Code.Let")
End Property

Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler

  ml_U_Code = al_U_Code
  Exit Property
ErrHandler:
  Call ErrorMessage("U_Code.Let")
End Property

Public Property Let LoginName(ByVal as_loginName As String)
On Error GoTo ErrHandler
    
    ms_LoginName = as_loginName
    Exit Property
ErrHandler:
    Call ErrorMessage(Me.Name & ".LoginName(Let)")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo ErrHandler
  
  Set mo_Db = lo_Db
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property

Public Property Let DC_Code(ByVal as_DC_Code As String)
    ms_DC_Code = as_DC_Code
End Property

Public Property Let DC_name(ByVal as_DC_Name As String)
    ms_DC_Name = as_DC_Name
End Property

Public Property Let ShippingDay(ByVal ad_shippingDay As Date)
    md_shippingDay = ad_shippingDay
End Property

Public Property Let TRANS_Code(ByVal al_Code As Long)
    ml_d = al_Code
End Property

Public Property Let TableName(ByVal as_tableName As String)
    ms_TableName = as_tableName
End Property

Private Sub AddDay()
Dim ll_Cursor As Long
Dim li_Day As Long
Dim ls_req As String
Dim ld_AddDate As Date

On Error GoTo ErrHandler

    ls_req = "EXEC DC_AddDay_sel 'Customer', '" & ms_DC_Code & "', ''"
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    
    If Not mo_Db.EOF(ll_Cursor) Then
        li_Day = mo_Db.GetFields(ll_Cursor, "DaysToAdd")
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0

    ld_AddDate = StringToDate(right(txt_ShipDate, 10))
    txt_DeliveryDate = DateToString(DateAdd("d", li_Day, ld_AddDate))
    
    Exit Sub

ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler("AddDay")
End Sub

Private Function ControlOver()
Dim ls_req As String
Dim ll_Cursor As Long

ControlOver = KO

On Error GoTo suite

    ls_req = "EXEC DC_WFCustomer '" _
        & QuoteParam(ms_DC_Code) & "', '" _
        & QuoteParam(FormatD(txt_ShipDate, "mm/dd/yyyy")) & "'," _
        & ml_d & "," _
        & SQLNum(txt_palletes.Text)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    
    Dim ls_OverPallDCFrom As String
    Dim ll_OverPallDiff As Long
    
    ls_OverPallDCFrom = mo_Db.GetFields(ll_Cursor, "OverPallDCFrom")
    ll_OverPallDiff = mo_Db.GetFields(ll_Cursor, "OverPallDiff")
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    If ls_OverPallDCFrom = "Y" Then
        ReDim ms_MsgInfo(0, 1)
        ms_MsgInfo(0, 0) = "$OverPallDiff$"
        ms_MsgInfo(0, 1) = ll_OverPallDiff
        If MsgBox(MsgText(5040, ms_Language_Code, "Customer Calendar Max pallets exceeded by $OverPallDiff$!" & Chr(10) & "Confirm ?", ms_MsgInfo), vbQuestion + vbYesNo, "Over Load") = vbNo Then
            ssp_quit.SetFocus
            Exit Function
        End If
    End If
    
    
    If ls_OverPallDCFrom = "Y" Then
        ls_req = "EXEC Workflow_DCLoadPlan '" _
            & QuoteParam(ms_DC_Code) & "', '" _
            & FormatD(txt_ShipDate, "mm/dd/yyyy") _
            & "', 'Customer', ' Customer. Date : '"
            
        Call ExecuteSQLSafe(mo_Db, ls_req)
        
    End If
    ControlOver = OK
Exit Function

suite:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler("ControlOver")
End Function


Private Sub RefreshMasterTran(ByVal ab_keepSelection As Boolean)
On Error GoTo ErrHandler
        
    Dim ls_oldTran As String
    ls_oldTran = ""
    If ab_keepSelection Then
        ls_oldTran = GetCboKey(cbo_masterTran)
    End If
        
    Call cbo_masterTran.Clear
        
    cbo_masterTran.Request = "EXEC DC_MasterTrans_cbo " & SqlStr(ms_DC_Code, 4, True) & ", " & SqlStr(GetCboKey(cbo_carrier), 10, True) & ", 'C', " & SqlDate(md_shippingDay) & ", " & SQLNum(ls_oldTran)

    If ab_keepSelection Then
        Call SetComboItemValue(cbo_masterTran, ls_oldTran)
    End If

    Exit Sub
ErrHandler:
    Call ErrorHandler("RefreshMasterTran")
End Sub

Private Sub RefreshCTInfo(ByVal ab_keepSelection As Boolean)
On Error GoTo ErrHandler

    Dim ls_prevUOM_Code As String
    Dim ls_prevCT_Code As String
    Dim ls_prevPostCode As String
    Dim ls_prevDCS_Code As String
    
    If ab_keepSelection Then
        ls_prevCT_Code = GetCboKey(cbo_country)
        ls_prevUOM_Code = GetCboKey(cbo_UOM)
        ls_prevPostCode = cbo_postCode.Text
'        ls_prevDCS_Code = GetCboKey(cbo_surcharges)
    End If
    
    If SupportPriceList Then
        ' we can fill list the countries based on DC/Carrier/Shipping date
        
        cbo_country.Clear
        cbo_UOM.Clear
        
        If chk_manualPrice.Value = vbChecked Then
            
            cbo_country.Request = "EXEC countries_cbo " & SqlStr(ms_Language_Code, 1)
            cbo_UOM.Request = "EXEC DC_PriceListUOM_cbo_all " & SQLNum(GetCboValue(cbo_carrier, "DC_CARRIER_Code")) & ", 'C', " & SqlDate(md_shippingDay) & "," & SqlStr(ms_Language_Code, 1)
        
        Else
            
            cbo_country.Request = "EXEC DC_PriceListCountries_cbo " & SQLNum(GetCboValue(cbo_carrier, "DC_CARRIER_Code")) & ", 'C', " & SqlDate(md_shippingDay) & "," & SqlStr(ms_Language_Code, 1)
            cbo_UOM.Request = "EXEC DC_PriceListUOM_cbo " & SQLNum(GetCboValue(cbo_carrier, "DC_CARRIER_Code")) & ", 'C', " & SqlDate(md_shippingDay) & "," & SqlStr(ms_Language_Code, 1)
            
            If ab_keepSelection Then
                ' try to see if there is only one line in cbo_UOM and pick it
                Call cbo_UOM.Load
                If cbo_UOM.Count = 1 Then
                    'we pick it
                    ls_prevUOM_Code = cbo_UOM.ComboItems(1).Key
                End If
            End If
        
        End If
        
        If ab_keepSelection Then
            If ls_prevCT_Code <> "" Then
                If SetComboItemValue(cbo_country, ls_prevCT_Code) Then
                    Call RefreshZIPInfo(ab_keepSelection)
                Else
                    cbo_postCode.Clear
                End If
            End If
            
            If ls_prevUOM_Code <> "" Then
                Call SetComboItemValue(cbo_UOM, ls_prevUOM_Code)
            End If
            
            If ls_prevDCS_Code <> "" Then
'                Call SetComboItemValue(cbo_surcharges, ls_prevDCS_Code)
            End If
            
        Else
            Call cbo_postCode.Clear
'            Call cbo_surcharges.Clear
'            Call cbo_surcharges.Load
'            Call cbo_surcharges.SearchItem("X", "DCS_Default")
        End If
    
    Else
        
        cbo_country.Clear
        cbo_postCode.Clear
'        cbo_surcharges.Clear
'        cbo_surcharges.Request = ""
        
        If chk_manualPrice.Value = vbChecked Then
            
            cbo_country.Request = "EXEC countries_cbo " & SqlStr(ms_Language_Code, 1)
        
            If ab_keepSelection Then
                
                If ls_prevCT_Code <> "" Then
                    Call SetComboItemValue(cbo_country, ls_prevCT_Code)
                End If
                
                cbo_postCode.Text = ls_prevPostCode
                
            End If
        Else
            
            cbo_country.Request = ""
        
        End If
        
        cbo_UOM.Clear
        cbo_UOM.Request = "EXEC DC_UOM_cbo2"
        
        If ab_keepSelection Then
            
            If ls_prevUOM_Code <> "" Then
                Call SetComboItemValue(cbo_UOM, ls_prevUOM_Code)
            End If
        
        End If

    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("RefreshCTInfo")
End Sub

Private Sub RefreshZIPInfo(ByVal ab_keepSelection As Boolean)
On Error GoTo ErrHandler

    If SupportPriceList And GetCboKey(cbo_country) <> "" Then
        ' we can fill list the post codes based on DC/Carrier/Shipping date/CT_Code
        Dim ls_prevZip_Code As String
        If ab_keepSelection Then
            ls_prevZip_Code = cbo_postCode.Text             ' GetCboKey(cbo_postCode)
        End If
        
        Call FillPostCombo(GetCboValue(cbo_carrier, "DC_CARRIER_Code"), md_shippingDay, GetCboKey(cbo_country), ls_prevZip_Code)
        
    Else
        Call cbo_postCode.Clear
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("RefreshZIPInfo")
End Sub

Private Sub RefreshSurchargeInfo(ByVal ab_keepSelection As Boolean)
On Error GoTo ErrHandler
Const C_REQ_EDIT As String = "EXEC DC_PriceListSurcharge_lst2 $0$ ,$DC_CARRIER_Code$, 'C', $TRANS_Date$, $Ship_To_CT_Code$, $Ship_To_Zip_Code$, $LANGUAGE_CODE$"
Const C_REQ_VIEW As String = "EXEC DC_PriceListSurcharge_lst3 $0$ , $LANGUAGE_CODE$"
    
    Dim ls_req As String
    Dim ll_i As Long
    Dim lb_hasSelection As Boolean
    lb_hasSelection = False
    
    Dim lb_supportSurcharge As Boolean
    lb_supportSurcharge = Val(GetCboValue(cbo_carrier, "DCS_Count", "0")) > 0
    
    If SupportPriceList And lb_supportSurcharge And GetCboKey(cbo_country) <> "" And cbo_postCode.Text <> "" Then
        ' we can fill list the post codes based on DC/Carrier/Shipping date/CT_Code
        Dim lla_prevDCS_Code() As String
        If ab_keepSelection Then
            If ckv_surcharges.CheckedCount > 0 Then
                ReDim lla_prevDCS_Code(ckv_surcharges.CheckedCount - 1) As String
                Dim ll_checked_ind As Long
                ll_checked_ind = LBound(lla_prevDCS_Code)
                For ll_i = 1 To ckv_surcharges.Count
                    If ckv_surcharges.ListItems(ll_i).Checked Then
                        lla_prevDCS_Code(ll_checked_ind) = ckv_surcharges.ListItems(ll_i).Tag.Id
                        ll_checked_ind = ll_checked_ind + 1
                    End If
                Next
                lb_hasSelection = True
            End If
        End If
        
        
        
        ckv_surcharges.Visible = False
        ckv_surcharges.Clear
      
        Select Case gs_Action
    
            Case "Add", "Update"
                ls_req = Replace(C_REQ_EDIT, "$LANGUAGE_CODE$", SqlStr(ms_Language_Code, 1), , , vbTextCompare)
                ckv_surcharges.EditRequest = Item_ReplacePlaceholders(ls_req)
                ckv_surcharges.MasterID = ml_d
                ckv_surcharges.Mode = ListLoadMode.ModeEdit
            
            Case Else
                ckv_surcharges.ViewRequest = Replace(C_REQ_VIEW, "$LANGUAGE_CODE$", SqlStr(ms_Language_Code, 1), , , vbTextCompare)
                ckv_surcharges.MasterID = ml_d
                ckv_surcharges.Mode = ListLoadMode.ModeView
        End Select
        
        ckv_surcharges.LoadList
        ckv_surcharges.Visible = True
        
        If ab_keepSelection Then
            
            If lb_hasSelection Then
                For ll_checked_ind = LBound(lla_prevDCS_Code) To UBound(lla_prevDCS_Code)
                    For ll_i = 1 To ckv_surcharges.Count
                        If ckv_surcharges.ListItems(ll_i).Tag.Id = lla_prevDCS_Code(ll_checked_ind) Then
                            ckv_surcharges.ListItems(ll_i).Checked = True
                        End If
                    Next
                Next
            Else
                For ll_i = 1 To ckv_surcharges.Count
                    If ckv_surcharges.ListItems(ll_i).Tag.GetData(SURCHARGE_COLS.DCS_Default) = "X" Then
                        ckv_surcharges.ListItems(ll_i).Checked = True
                    End If
                Next
            End If
        End If
        
    Else
        ckv_surcharges.Clear
        ckv_surcharges.Visible = lb_supportSurcharge
        lbl_surcharges.Visible = lb_supportSurcharge
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("RefreshSurchargeInfo")
End Sub

Private Function SaveCkvSurcharges(ml_TRANS_Code As Long) As Boolean
Const C_REQ_SURCHARGE_INS As String = "EXEC DC_Tran_Surcharge_ins $0$,$1$,1,$3$"
Const C_REQ_SURCHARGE_DEL As String = "EXEC DC_Tran_Surcharge_del2 $0$,$1$"

On Error GoTo errhHandler
    
    SaveCkvSurcharges = False
    
    ckv_surcharges.CheckRequest = C_REQ_SURCHARGE_INS
    ckv_surcharges.UnCheckRequest = C_REQ_SURCHARGE_DEL
    ckv_surcharges.MasterID = ml_TRANS_Code

    SaveCkvSurcharges = ckv_surcharges.SaveList
    Exit Function
    
errhHandler:
    Call ErrorHandler("SaveCkvSurcharges")
End Function

Private Sub FillPostCombo(ByVal al_DC_CARRIER_Code As Long, ad_Date As Date, ByVal as_CT_Code As String, ByVal as_Value As String)
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC DC_PriceListZipCode_cbo $DC_CARRIER_Code$, 'C', $TRANS_Date$, $CT_Code$, $LANGUAGE_CODE$"
    
    Dim ls_req As String
    Dim ll_Cursor As Long
    
    ls_req = Replace(C_REQ, "$DC_CARRIER_Code$", al_DC_CARRIER_Code, , , vbTextCompare)
    ls_req = Replace(ls_req, "$TRANS_Date$", SqlDate(ad_Date), , , vbTextCompare)
    ls_req = Replace(ls_req, "$CT_Code$", SqlStr(as_CT_Code, 4), , , vbTextCompare)
    ls_req = Replace(ls_req, "$LANGUAGE_CODE$", SqlStr(ms_Language_Code, 1), , , vbTextCompare)
    
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    
    Call cbo_postCode.Clear
    
    While Not mo_Db.EOF(ll_Cursor)
    
        cbo_postCode.AddItem (mo_Db.GetFields(ll_Cursor, "DCPLL_Zip_Code"))
        cbo_postCode.ItemData(cbo_postCode.ListCount - 1) = mo_Db.GetFields(ll_Cursor, "DCPLL_Code")
        
        Call mo_Db.Next(ll_Cursor)
    Wend
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    cbo_postCode.Text = as_Value

    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler("FillPostCombo")
End Sub

Private Sub FillMasterTrans(ByVal al_TRANS_Code As Long)
On Error GoTo ErrHandler

Const C_REQ As String = "EXEC DC_MasterTrans_sel $TRANS_Code$"

Dim ll_Cursor As Long
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(C_REQ, "$TRANS_Code$", al_TRANS_Code))

    txt_tranOrder = mo_Db.GetFields(ll_Cursor, "TRANS_Order") + 1
    txt_COSContact = mo_Db.GetFields(ll_Cursor, "COS_Contact")
    txt_TrailerNb = mo_Db.GetFields(ll_Cursor, "Trailer_Number")
    txt_HaulierBookNb = mo_Db.GetFields(ll_Cursor, "Haulier_Booking_Number")
    txt_LoadBy = mo_Db.GetFields(ll_Cursor, "Load_By")
    
    Call SetComboItemValue(cbo_carrier, mo_Db.GetFields(ll_Cursor, "CARRIER_Code"))
    Call RefreshCTInfo(True)
    Call SetComboItemValue(cbo_Equipement, mo_Db.GetFields(ll_Cursor, "EQ_code"))
'    Call SetComboItemValue(cbo_country, mo_Db.GetFields(ll_cursor, "Ship_To_CT_Code"))
    Call RefreshZIPInfo(True)
'    cbo_postCode.Text = mo_Db.GetFields(ll_cursor, "Ship_To_Zip_Code")
    Call RefreshSurchargeInfo(True)
    Call SetComboItemValue(cbo_UOM, mo_Db.GetFields(ll_Cursor, "UOM_code"))
    Call SetComboItemValue(cbo_currency, mo_Db.GetFields(ll_Cursor, "CUST_FC_Currency"))
    
    If mo_Db.GetFields(ll_Cursor, "Stand_Trailer") = "Y" Then
        Opt_Yes.Value = True
    Else
        Opt_No.Value = True
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Dim ll_CurrentLine As Long
    
    ll_CurrentLine = GetDCTransportLine(ml_d)
    
    moa_DCTransport_cost(ll_CurrentLine).DCPL_Code = Val(GetCboValue(cbo_UOM, "DCPL_Code"))
    moa_DCTransport_cost(ll_CurrentLine).UOM_Code = GetCboKey(cbo_UOM)
'    moa_DCTransport_cost(ll_CurrentLine).DCPLL_Code = IIf(GetCboValue(cbo_postCode, "DCPLL_Code") = "", 0, GetCboValue(cbo_postCode, "DCPLL_Code"))
    
    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler("FillMasterTrans")
End Sub



Private Function SqlDate(ByVal av_Data As Variant) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("SqlDate")
End Function

' translate string to sql format
' Params:
' as_Value (String)
' ab_EmptyNULL (Boolean = False)
Private Function SqlStr(ByVal as_Value As String, Optional ByVal al_MaxLen As Long = 8000, Optional ByVal ab_EmptyNULL As Boolean = False) As String
    If as_Value = "" And ab_EmptyNULL Then
        SqlStr = "NULL"
    Else
        SqlStr = "'" & Replace(Left(as_Value, IIf(Len(as_Value) <= al_MaxLen, Len(as_Value), al_MaxLen)), "'", "''") & "'"
    End If
End Function


Private Function SQLNum(ByVal as_str As String) As String
    If as_str = "" Then
        SQLNum = "NULL"
    Else
        SQLNum = Replace(as_str, ",", ".")
    End If
End Function




Private Sub btn_SAP_SearchData_Click()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    mb_eventRunning = True

    If Trim(txt_CLSOrderNb.Text) = "" Then Exit Sub

    Call LockScreen(True)
    
    Dim lsa_order() As String
    lsa_order = Split(txt_CLSOrderNb.Text, " ")
    
    Call UpdateSAPData(ReturnNonAlpha(lsa_order(UBound(lsa_order))))
    
    Call LockScreen(False)
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    ErrorMessage ("btn_SAP_SearchData_Click")
End Sub

Private Sub cbo_Carrier_ComboItemSelected()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    mb_eventRunning = True
    
    Call LockScreen(True)
    
    Call RefreshMasterTran(True)
    
    Call RefreshCTInfo(True)
    
    Call RefreshSurchargeInfo(True)
    
    Call UpdatePriceListUI
    
    mb_eventRunning = False
    
    Dim ll_Index As Long
    ll_Index = GetDCTransportLine(ml_d)
    
    Dim ll_newDCPL_Code As Long
    
    ll_newDCPL_Code = Val(GetCboValue(cbo_UOM, "DCPL_Code"))
    
    If moa_DCTransport_cost(ll_Index).DCPL_Code = ll_newDCPL_Code Then
        Call LockScreen(False)
        Exit Sub
    End If
    
    moa_DCTransport_cost(ll_Index).DCPL_Code = ll_newDCPL_Code
    moa_DCTransport_cost(ll_Index).UOM_Code = GetCboKey(cbo_UOM)
    
    Call GenerateTransportCost
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost
    
    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    ErrorMessage ("cbo_carrier_ComboItemSelected")
End Sub


Private Sub cbo_country_ComboItemSelected()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    
    mb_eventRunning = True
    
    Call LockScreen(True)
    
    Call RefreshZIPInfo(cbo_postCode.ListIndex = -1)
    
    Call RefreshSurchargeInfo(True)
    
    mb_eventRunning = False
    
'    Dim ll_Index As Long
'    ll_Index = GetDCTransportLine(ml_d)
    
'    Dim ll_newDCPLL_Code As Long
    
'    ll_newDCPLL_Code = IIf(GetCboValue(cbo_postCode, "DCPLL_Code") = "", 0, GetCboValue(cbo_postCode, "DCPLL_Code"))
    
'    If moa_DCTransport_cost(ll_Index).DCPLL_Code = ll_newDCPLL_Code Then
'        Exit Sub
'    End If
    
'    moa_DCTransport_cost(ll_Index).DCPLL_Code = ll_newDCPLL_Code
    
    Call GenerateTransportCost
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost
    
    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("cbo_country_ComboItemSelected")
End Sub

Private Sub cbo_delivery_Click()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    mb_eventRunning = True
        
    Call LockScreen(True)

    Dim lsa_Array() As String
    
    lsa_Array = Split(cbo_delivery.Text, "/", , vbTextCompare)
    Debug.Assert (UBound(lsa_Array) >= 0)
    
    If UBound(lsa_Array) >= 1 Then
        Call SearchSAPData(lsa_Array(0), lsa_Array(1))
    Else
        Call SearchSAPData(lsa_Array(0), "")
    End If
    
    Call LockScreen(False)
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("cbo_delivery_Change")
End Sub

Private Function ReturnNonAlpha(ByVal as_str As String) As String
On Error GoTo ErrHandler
    ReturnNonAlpha = ""
    
    Dim ls_retVal As String
    ls_retVal = ""
    
    Dim ll_i As Long
    For ll_i = 1 To Len(as_str)
        If isNumeric(Mid(as_str, ll_i, 1)) Then
            ls_retVal = ls_retVal & Mid(as_str, ll_i, 1)
        End If
    Next
    
    ReturnNonAlpha = ls_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler("ReturnNonAlpha")
End Function

Private Sub SearchSAPData(ByVal as_delivery As String, ByVal as_deliveryItem As String)
On Error GoTo ErrHandler

    Debug.Assert (mb_eventRunning)
    
    Dim lb_VBPALoaded As Boolean
    lb_VBPALoaded = False
        
    Dim lo_XMLParam As New SvcXMLParam
    Dim lo_XMLItem As MSXML2.IXMLDOMNode
    
'  1. we use order data
    Set lo_XMLItem = mo_sapXML.selectSingleNode("/DataSet/VBPA/row[PARVW='WE']")
    
    If Not lo_XMLItem Is Nothing Then
    
        txt_CustName.Text = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "ADRNR/row/NAME1")
        
        txt_ShipAdd.Text = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "ADRNR/row/POST_CODE1") + " " + lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "ADRNR/row/CITY1")
        
        If SetComboItemValue(cbo_country, lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "ADRNR/row/COUNTRY")) Then
        
            Call RefreshZIPInfo(False)
            
            ' search for nearest Postal code in the list
            
            Dim ll_selIndex As Long
            ll_selIndex = -1
            
            Dim ls_postCode As String
            Dim ll_postCodeLen As Long
            ls_postCode = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "ADRNR/row/POST_CODE1")
            ll_postCodeLen = Len(ls_postCode)
            
            Dim ll_i As Long
            For ll_i = 0 To cbo_postCode.ListCount - 1
                If cbo_postCode.List(ll_i) = ls_postCode Then
                    ' exact match
                    ll_selIndex = ll_i
                    Exit For
                End If
                
                Dim ll_zipLen As Long
                ll_zipLen = Len(cbo_postCode.List(ll_i))
                
                If ll_postCodeLen > ll_zipLen Then
                    If Left(ls_postCode, ll_zipLen) = cbo_postCode.List(ll_i) Then
                        If ll_selIndex = -1 Then
                            ll_selIndex = ll_i
                        ElseIf Len(cbo_postCode.List(ll_selIndex)) < ll_zipLen Then
                            ' in case current match is longer than previouse
                            ll_selIndex = ll_i
                        End If
                    End If
                End If
                
            Next
            
            If ll_selIndex <> -1 Then
                cbo_postCode.ListIndex = ll_selIndex
            Else
                cbo_postCode.Text = FindBestMatchingPostCode(lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "ADRNR/row/POST_CODE1"))
            End If
            
            Call RefreshSurchargeInfo(True)
            
        End If
        
        Call GenerateTransportCost
        
        Call GenerateSurchargeCost
        
        Call UpdateTotalCost
                    
        lb_VBPALoaded = True
        
        Set lo_XMLItem = Nothing
        
    End If
    
    If isNumeric(as_delivery) Then
    
        as_delivery = Format(Val(as_delivery), "0000000000")
        
        
        If as_deliveryItem = "" Or Not isNumeric(as_deliveryItem) Then
            Set lo_XMLItem = mo_sapXML.selectSingleNode("/DataSet/inforow[DELIV_NUMB='" & as_delivery & "']")
        Else
            Set lo_XMLItem = mo_sapXML.selectSingleNode("/DataSet/inforow[DELIV_NUMB='" & as_delivery & "' and DELIV_ITEM='" & Format(Val(as_deliveryItem), "000000") & "' ]")
        End If
    End If
    
    If Not (lo_XMLItem Is Nothing) Then
    
        cbo_delivery.Text = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "DELIV_NUMB")
        
        txt_CLSShipNb.Text = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "VTTP/row/TKNUM")
        
        If Not lb_VBPALoaded Then
        
            txt_CustName.Text = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "KUNNR_KNA1/row/NAME1")
        
            txt_ShipAdd.Text = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "KUNNR_KNA1/row/PSTLZ") + " " + lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "KUNNR_KNA1/row/ORT01")
        
            If SetComboItemValue(cbo_country, lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "KUNNR_KNA1/row/LAND1")) Then
        
                Call RefreshZIPInfo(False)
                
                cbo_postCode.Text = FindBestMatchingPostCode(lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "KUNNR_KNA1/row/PSTLZ"))
                
                Call RefreshSurchargeInfo(True)
                
            End If
    
            Call GenerateTransportCost
            
            Call GenerateSurchargeCost
            
            Call UpdateTotalCost
            
        End If
    ElseIf Not lb_VBPALoaded Then
        Call MsgBox(MsgText(5050, ms_Language_Code, "#No SAP data found!!!"), vbInformation Or vbOKOnly)
    End If

    Exit Sub
ErrHandler:
    mb_eventRunning = False
    Call ErrorHandler("SearchSAPData")
End Sub

Private Function FindBestMatchingPostCode(ByVal as_ZIP As String) As String
On Error GoTo ErrHandler

    FindBestMatchingPostCode = ""

    Dim ls_retVal As String
    ls_retVal = ""
    
    Dim ll_retCounter As Long
    ll_retCounter = 0
    
    Dim ll_maxLen As Long
    ll_maxLen = -1
    
    Dim ll_len As Long
    
    Dim ll_i As Long
    For ll_i = 0 To cbo_postCode.ListCount - 1
        ll_len = Len(cbo_postCode.List(ll_i))
        If cbo_postCode.List(ll_i) = Left(as_ZIP, ll_len) Then
            ' we have a candidate
            If ll_len > ll_maxLen Then
                ls_retVal = cbo_postCode.List(ll_i)
                ll_maxLen = ll_len
                ll_retCounter = 1
            ElseIf ll_len = ll_maxLen Then
                ll_retCounter = ll_retCounter + 1
            End If
        End If
    Next
    
    If ls_retVal <> "" Then
        FindBestMatchingPostCode = ls_retVal
    Else
        FindBestMatchingPostCode = as_ZIP
    End If
    

    Exit Function
ErrHandler:
    Call ErrorHandler("FindBestMatchingPostCode")
End Function

Private Sub cbo_masterTran_ComboItemSelected()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    mb_eventRunning = True

    Call LockScreen(True)
    
    If GetCboKey(cbo_masterTran) <> "" Then
        Call FillMasterTrans(cbo_masterTran.SelectedItem.Key)
    Else
        txt_tranOrder.Text = "1"
    End If
    
    Call InitTransportCost(ml_d, Val(GetCboKey(cbo_masterTran)), Val(GetCboValue(cbo_UOM, "DCPL_Code")))
    
    Call GenerateTransportCost
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost
    
    Call UpdatePriceListUI

    Call UpdateMasterTransUI
    
    mb_eventRunning = False
    
    Call LockScreen(False)
    
    Exit Sub
    
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("cbo_masterTran_ComboItemSelected")
End Sub

Private Sub cbo_postCode_Validate(Cancel As Boolean)
On Error GoTo ErrHandler
    
    If chk_manualPrice.Value = vbChecked Then Exit Sub     ' nothing to do when no manual update
    
    If cbo_postCode.ListIndex <> -1 Then Exit Sub          ' nothing to do when selected from the list
    
    If cbo_postCode.Text = "" Then Exit Sub                ' nothing to do when empty text with listindex -1
    
    ' just check if cbo_postcode is in the list
    Dim ls_Text As String
    ls_Text = cbo_postCode.Text
    
    Dim ll_i As Long
    For ll_i = 0 To cbo_postCode.ListCount - 1
        If cbo_postCode.List(ll_i) = ls_Text Then
            cbo_postCode.ListIndex = ll_i
            Exit Sub
        End If
    Next
    
    Cancel = True
    Exit Sub
    
ErrHandler:
    Call ErrorMessage("cbo_postCode_Validate")
End Sub

Private Sub chk_isReturn_Click()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    
    mb_eventRunning = True
    
'    Call RefreshSurchargeInfo(True)
    
    Call GenerateTransportCost
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost
    
    mb_eventRunning = False
    
    Exit Sub
ErrHandler:
    mb_eventRunning = False
    Call ErrorMessage(Me.Name & ".chk_isReturn_Click()")
End Sub

Private Sub chk_manualPrice_Click()
On Error GoTo ErrHandler
    
    If chk_manualPrice.Value = vbUnchecked And cbo_postCode.ListIndex = -1 Then
        cbo_postCode.Text = ""
    End If
    
    cbo_Carrier_ComboItemSelected

    Exit Sub
    
ErrHandler:
    Call ErrorMessage("chk_manualPrice_Click")
End Sub



Private Sub ckv_surcharges_ItemCheck(ByVal Item As MSComctlLib.ListItem)
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    
    mb_eventRunning = True
    
    Call LockScreen(True)
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost

    mb_eventRunning = False

    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("ckv_surcharges_ItemCheck")
End Sub


Private Sub DCCost1_RowUpdated(ByVal as_action As String, ByVal as_CostType As String, ByVal ad_Value As Double)
On Error GoTo ErrHandler
    
    Dim ll_CurrentLine As Long
    ll_CurrentLine = GetDCTransportLine(ml_d)
    
    Select Case as_action
    
        Case "Add", "Update"
            If as_CostType = "M" Then
                moa_DCTransport_cost(ll_CurrentLine).Manual_Cost = ad_Value
            Else
                moa_DCTransport_cost(ll_CurrentLine).DCPLLI_Price = ad_Value
            End If
        Case "Delete"
            If as_CostType = "M" Then
                moa_DCTransport_cost(ll_CurrentLine).Manual_Cost = 0
            Else
                moa_DCTransport_cost(ll_CurrentLine).DCPLLI_Price = 0
            End If
    End Select

    Dim lb_isFullTruck As Boolean
    Dim lb_isFullTruckCost As Boolean
    Dim lb_overLoaded As Boolean
    Dim lb_overLoadedCost As Boolean
    Dim lb_mixedUOM As Boolean
    Dim lb_isTrailer As Boolean

    Call CheckTransportCost(Val(GetCboValue(cbo_UOM, "DropOff_Cost", "0")), GetCboValue(cbo_UOM, "FullTruckCalculation", "Y"), lb_isFullTruck, lb_overLoaded, lb_overLoadedCost, lb_mixedUOM, lb_isFullTruckCost, lb_isTrailer)

    txt_totalCost.Text = Format(GetTotalCost(lb_isFullTruckCost, Val(GetCboValue(cbo_UOM, "DropOff_Cost")), md_manualCost, True), "###0.00")
        
    Exit Sub
ErrHandler:
    Call ErrorMessage("DCCost1_RowUpdated")
End Sub

Private Sub Form_Activate()
On Error GoTo ErrHandler
    
    If gs_Action = "Delete" Then
        spp_save.SetFocus
    ElseIf gs_Action = "MoreInfo" Then
        ssp_quit.SetFocus
    ElseIf ms_TableName = "DC_Customer" Then
        cbo_carrier.SetFocus
    ElseIf ms_TableName = "DC_Cust_End" Then
        txt_HaulierBookNb.SetFocus
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage("Form_Activate")
End Sub

Private Sub btn_OK2_Click()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    
    Call Me.ValidateControls
    mb_eventRunning = True
    
    Call LockScreen(True)
    
    gb_Return = OK
    
    Debug.Assert (gs_Action = "Add")
    
    If Add_Table Then
        
        Dim ls_prevMaster As String
        ls_prevMaster = GetCboKey(cbo_masterTran)
        
        If ls_prevMaster = "" Then ls_prevMaster = ml_d
        
        Call Item_Clear
        Call Item_Load(0)
        ' select the master transaction from previouse add screen
        mb_eventRunning = False
        Call SetComboItemValue(cbo_masterTran, ls_prevMaster)
        mb_eventRunning = True
        
    End If
        
    Call LockScreen(False)
    Me.Refresh
    DoEvents
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    If Err.Number = 380 Then        ' validation failed
        Exit Sub
    End If
    
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("btn_OK2_Click")
End Sub


Private Sub spp_save_Click()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    
    Call Me.ValidateControls
    
    mb_eventRunning = True
    Call LockScreen(True)
    gb_Return = OK
    Select Case gs_Action
    Case "Add":
        If Add_Table Then
            
            Call Item_Clear
            Call Item_Load(0)
        End If
    Case "Update":
        If Upd_Table Then
            Call LockScreen(False)
            Me.Hide
            mb_eventRunning = False
            Exit Sub
        End If
    Case "Delete":
        If Dlt_Table Then
            Call LockScreen(False)
            Me.Hide
            mb_eventRunning = False
            Exit Sub
        End If
    End Select
    
    Call LockScreen(False)
    Me.Refresh
    DoEvents
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    If Err.Number = 380 Then        ' validation failed
        Exit Sub
    End If
    
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("spp_save_Click")
End Sub




Private Sub SSDeliveryDate_Click()
On Error GoTo suite
    Call LockScreen(True)
    gb_Return = KO
    gs_Date = txt_DeliveryDate
    Dates.show 1
    If gb_Return Then
        txt_DeliveryDate = gs_Date
    End If
    Call LockScreen(False)
    Exit Sub
suite:
    Call LockScreen(False)
    Call ErrorMessage("SSDeliveryDate_Click")
End Sub


Private Sub ssp_quit_Click()
    Me.Hide
End Sub


Private Sub SSShipDate_Click()
On Error GoTo suite
    Call LockScreen(True)
    gb_Return = KO
    gs_Date = txt_ShipDate
    Dates.show 1
    If gb_Return Then
        txt_ShipDate = gs_Date
        md_shippingDay = gs_Date
        
        Call RefreshMasterTran(True)
        
    End If
    Call LockScreen(False)
Exit Sub
suite:
    Call LockScreen(False)
    Call ErrorMessage("SSShipDate_Click")
End Sub

Private Sub txt_ArrivalTime_GotFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)
    
    If Len(txt_ArrivalTime) = 5 Then
        txt_ArrivalTime = Left(txt_ArrivalTime, 2) & right(txt_ArrivalTime, 2)
    End If

    txt_ArrivalTime.SelStart = 0
    txt_ArrivalTime.SelLength = Len(txt_ArrivalTime)

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_ArrivalTime_GotFocus")
End Sub


Private Sub txt_ArrivalTime_LostFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)
    
    If Len(txt_ArrivalTime) = 5 And Mid(txt_ArrivalTime, 3, 1) = ":" Then
        txt_ArrivalTime = Left(txt_ArrivalTime, 2) & right(txt_ArrivalTime, 2)
    End If

    If Not CheckNumericValue(txt_ArrivalTime) Then
        SendMessage 5130, "Only numeric field is valid !", gut_LangLogin.Code
        txt_ArrivalTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    End If

    If Len(txt_ArrivalTime) <> 4 Then
        SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
        txt_ArrivalTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    Else
        If Left(txt_ArrivalTime, 2) > 23 Or right(txt_ArrivalTime, 2) > 59 Then
            SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
            txt_ArrivalTime.SetFocus
        Else
            txt_ArrivalTime = Left(txt_ArrivalTime, 2) & ":" & right(txt_ArrivalTime, 2)
        End If
    End If

    Call LockScreen(False)

    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_ArrivalTime_LostFocus")
End Sub


Private Sub txt_deliverydate_Change()
On Error GoTo ErrHandler
    If txt_DeliveryDate = "" Then Exit Sub
    
    If mb_eventRunning Then Exit Sub
    
    Call LockScreen(True)

    If DateDiff("d", StringToDate(txt_DeliveryDate), StringToDate(txt_ShipDate)) > 0 Then
        SendMessage 5150, "The delivery date must be greater" & Chr(10) & "than the shipping date", gut_LangLogin.Code
        txt_DeliveryDate.SetFocus
    End If
    
    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_deliverydate_Change")
End Sub

Private Sub txt_LoadEndTime_GotFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)
    
    If Len(txt_LoadEndTime) = 5 Then
        txt_LoadEndTime = Left(txt_LoadEndTime, 2) & right(txt_LoadEndTime, 2)
    End If

    txt_LoadEndTime.SelStart = 0
    txt_LoadEndTime.SelLength = Len(txt_LoadEndTime)

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")
End Sub


Private Sub txt_LoadEndTime_LostFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)

    If Len(txt_LoadEndTime) = 5 And Mid(txt_LoadEndTime, 3, 1) = ":" Then
        txt_LoadEndTime = Left(txt_LoadEndTime, 2) & right(txt_LoadEndTime, 2)
    End If

    If Not CheckNumericValue(txt_LoadEndTime) Then
        SendMessage 5130, "Only numeric field is valid !", gut_LangLogin.Code
        txt_LoadEndTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    End If

    If Len(txt_LoadEndTime) <> 4 Then
        SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
        txt_LoadEndTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    Else
        If Left(txt_LoadEndTime, 2) > 23 Or right(txt_LoadEndTime, 2) > 59 Then
            SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
            txt_LoadEndTime.SetFocus
        Else
            txt_LoadEndTime = Left(txt_LoadEndTime, 2) & ":" & right(txt_LoadEndTime, 2)
        End If
    End If

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")
End Sub


Private Sub txt_LoadPlanEndTime_GotFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)
    
    If Len(txt_LoadPlanEndTime) = 5 Then
        txt_LoadPlanEndTime = Left(txt_LoadPlanEndTime, 2) & right(txt_LoadPlanEndTime, 2)
    End If

    txt_LoadPlanEndTime.SelStart = 0
    txt_LoadPlanEndTime.SelLength = Len(txt_LoadPlanEndTime)

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")
End Sub


Private Sub txt_LoadPlanEndTime_LostFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)

    If Len(txt_LoadPlanEndTime) = 5 And Mid(txt_LoadPlanEndTime, 3, 1) = ":" Then
        txt_LoadPlanEndTime = Left(txt_LoadPlanEndTime, 2) & right(txt_LoadPlanEndTime, 2)
    End If

    If Not CheckNumericValue(txt_LoadPlanEndTime) Then
        SendMessage 5130, "Only numeric field is valid !", gut_LangLogin.Code
        txt_LoadPlanEndTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    End If

    If Len(txt_LoadPlanEndTime) <> 4 Then
        SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
        txt_LoadPlanEndTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    Else
        If Left(txt_LoadPlanEndTime, 2) > 23 Or right(txt_LoadPlanEndTime, 2) > 59 Then
            SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
            txt_LoadPlanEndTime.SetFocus
        Else
            txt_LoadPlanEndTime = Left(txt_LoadPlanEndTime, 2) & ":" & right(txt_LoadPlanEndTime, 2)
        End If
    End If

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")

End Sub


Private Sub txt_LoadPlanStartTime_GotFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)

    If Len(txt_LoadPlanStartTime) = 5 Then
        txt_LoadPlanStartTime = Left(txt_LoadPlanStartTime, 2) & right(txt_LoadPlanStartTime, 2)
    End If

    txt_LoadPlanStartTime.SelStart = 0
    txt_LoadPlanStartTime.SelLength = Len(txt_LoadPlanStartTime)

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")
End Sub


Private Sub txt_LoadPlanStartTime_LostFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)

    If Len(txt_LoadPlanStartTime) = 5 And Mid(txt_LoadPlanStartTime, 3, 1) = ":" Then
        txt_LoadPlanStartTime = Left(txt_LoadPlanStartTime, 2) & right(txt_LoadPlanStartTime, 2)
    End If

    If Not CheckNumericValue(txt_LoadPlanStartTime) Then
        SendMessage 5130, "Only numeric field is valid !", gut_LangLogin.Code
        txt_LoadPlanStartTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    End If

    If Len(txt_LoadPlanStartTime) <> 4 Then
        SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
        txt_LoadPlanStartTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    Else
        If Left(txt_LoadPlanStartTime, 2) > 23 Or right(txt_LoadPlanStartTime, 2) > 59 Then
            SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
            txt_LoadPlanStartTime.SetFocus
        Else
            txt_LoadPlanStartTime = Left(txt_LoadPlanStartTime, 2) & ":" & right(txt_LoadPlanStartTime, 2)
        End If
    End If

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")

End Sub

Private Function FormatTime(ByVal as_Time As String) As String
On Error GoTo ErrHandler
    If Len(as_Time) = 4 Then
        FormatTime = Left(txt_LoadPlanStartTime, 2) & ":" & right(txt_LoadPlanStartTime, 2)
    Else
        FormatTime = as_Time
    End If

    Exit Function
ErrHandler:
    Call ErrorHandler("FormatTime")
End Function

Private Sub txt_LoadStartTime_GotFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)

    If Len(txt_LoadStartTime) = 5 Then
        txt_LoadStartTime = Left(txt_LoadStartTime, 2) & right(txt_LoadStartTime, 2)
    End If

    txt_LoadStartTime.SelStart = 0
    txt_LoadStartTime.SelLength = Len(txt_LoadStartTime)

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")
End Sub


Private Sub txt_LoadStartTime_LostFocus()
On Error GoTo ErrHandler
    Call LockScreen(True)

    If Len(txt_LoadStartTime) = 5 And Mid(txt_LoadStartTime, 3, 1) = ":" Then
        txt_LoadStartTime = Left(txt_LoadStartTime, 2) & right(txt_LoadStartTime, 2)
    End If

    If Not CheckNumericValue(txt_LoadStartTime) Then
        SendMessage 5130, "Only numeric field is valid !", gut_LangLogin.Code
        txt_LoadStartTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    End If

    If Len(txt_LoadStartTime) <> 4 Then
        SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
        txt_LoadStartTime.SetFocus
        Call LockScreen(False)
        Exit Sub
    Else
        If Left(txt_LoadStartTime, 2) > 23 Or right(txt_LoadStartTime, 2) > 59 Then
            SendMessage 5140, "Wrong time format !", gut_LangLogin.Code
            txt_LoadStartTime.SetFocus
        Else
            txt_LoadStartTime = Left(txt_LoadStartTime, 2) & ":" & right(txt_LoadStartTime, 2)
        End If
    End If

    Call LockScreen(False)
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorMessage("txt_LoadEndTime_GotFocus")
End Sub



Private Function Control() As Boolean
On Error GoTo ErrHandler
    Control = KO
    
    If GetCboKey(cbo_carrier) = "" Then
        cbo_carrier.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If GetCboKey(cbo_Equipement) = "" Then
        cbo_Equipement.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If txt_CustName = "" Then
        txt_CustName.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If txt_ShipAdd = "" Then
        txt_ShipAdd.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If txt_CLSOrderNb = "" Then
        txt_CLSOrderNb.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If txt_DeliveryDate = "" Then
        txt_DeliveryDate.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If DateDiff("d", StringToDate(txt_DeliveryDate), StringToDate(txt_ShipDate)) > 0 Then
        SendMessage 8, "The delivery date must be greater" & Chr(10) & "than the shipping date", gut_LangLogin.Code
        txt_DeliveryDate.SetFocus
        Exit Function
    End If
    If txt_QuantityWeight = "" Then
        txt_QuantityWeight.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If Not CheckNumericValue(txt_QuantityWeight) Then
        SendMessage 8, "Value must be a numeric", gut_LangLogin.Code
        Call SetTextBoxFocus(txt_QuantityWeight)
        Exit Function
    End If
    
    If txt_RealQuantity = "" Then
        txt_RealQuantity.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    If Not CheckNumericValue(txt_RealQuantity) Then
        SendMessage 8, "Value must be a numeric", gut_LangLogin.Code
        Call SetTextBoxFocus(txt_RealQuantity)
        Exit Function
    End If
    
    If GetCboKey(cbo_UOM) = "" Then
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        cbo_UOM.SetFocus
        Exit Function
    End If

    If txt_tranOrder.Text = "" Then
        txt_tranOrder.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    
    If Not CheckNumericValue(txt_tranOrder) Then
        SendMessage 8, "Value must be a numeric", gut_LangLogin.Code
        Call SetTextBoxFocus(txt_tranOrder)
        Exit Function
    End If

    If txt_paidByCustomer.Text = "" Then
        txt_paidByCustomer.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If

    If Not CheckNumericValue(txt_paidByCustomer) Then
        SendMessage 8, "Value must be a numeric", gut_LangLogin.Code
        Call SetTextBoxFocus(txt_paidByCustomer)
        Exit Function
    End If

    If Val(txt_paidByCustomer.Text) <> 0# And cbo_currency.SelectedItem Is Nothing Then
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        cbo_UOM.SetFocus
        Exit Function
    End If
    
    If txt_palletes.Text = "" Then
        txt_palletes.SetFocus
        SendMessage 8, "Value must be filled in", gut_LangLogin.Code
        Exit Function
    End If
    
    If Not CheckNumericValue(txt_palletes) Then
        SendMessage 8, "Value must be a numeric", gut_LangLogin.Code
        Call SetTextBoxFocus(txt_palletes)
        Exit Function
    End If
    
    
    If SupportPriceList Then
    
        
        If GetCboKey(cbo_country) = "" Then
            SendMessage 8, "Value must be filled in", gut_LangLogin.Code
            cbo_country.SetFocus
            Exit Function
        End If
        
        If cbo_postCode.Text = "" Then
            SendMessage 8, "Value must be filled in", gut_LangLogin.Code
            cbo_postCode.SetFocus
            Exit Function
        End If
        
        ' check the cost
        Dim lb_isFullTruck As Boolean
        Dim lb_isFullTruckCost As Boolean
        Dim lb_overLoaded As Boolean
        Dim lb_overLoadedCost As Boolean
        Dim lb_mixedUOM As Boolean
        Dim lb_isTrailer As Boolean
    
        Call CheckTransportCost(Val(GetCboValue(cbo_UOM, "DropOff_Cost", "0")), GetCboValue(cbo_UOM, "FullTruckCalculation", "Y"), lb_isFullTruck, lb_overLoaded, lb_overLoadedCost, lb_mixedUOM, lb_isFullTruckCost, lb_isTrailer)
    
        If lb_overLoaded Then
            ReDim ms_MsgInfo(1, 1)
            ms_MsgInfo(0, 0) = "$QTY_FOR_TRANSPORT$"
            ms_MsgInfo(0, 1) = GetTotalQty(QTY_FOR_TRANSPORT)
            ms_MsgInfo(1, 0) = "$UOM$"
            ms_MsgInfo(1, 1) = GetCboKey(cbo_UOM)
            Call MsgBox(MsgText(5060, ms_Language_Code, "#Truck is overloaded!!! ($QTY_FOR_TRANSPORT$ $UOM$)", ms_MsgInfo), vbCritical Or vbOKOnly)
            
            txt_QuantityWeight.SetFocus
            Exit Function
        End If
    
        If lb_mixedUOM Then
            Call MsgBox(MsgText(5070, ms_Language_Code, "#Mixed UOM!"), vbCritical Or vbOKOnly)
            
            cbo_UOM.SetFocus
            Exit Function
        End If
        
        If lb_overLoadedCost Then
            ' warning
            ReDim ms_MsgInfo(1, 1)
            ms_MsgInfo(0, 0) = "$QTY_FOR_COST$"
            ms_MsgInfo(0, 1) = GetTotalQty(QTY_FOR_COST)
            ms_MsgInfo(1, 0) = "$UOM$"
            ms_MsgInfo(1, 1) = GetCboKey(cbo_UOM)
            Call MsgBox(MsgText(5080, ms_Language_Code, "#Ordered qty is overloading the truck! ($QTY_FOR_COST$ $UOM$)", ms_MsgInfo), vbInformation Or vbOKOnly)
        End If
    Else
        If chk_manualPrice.Value = vbChecked Then
            If GetCboKey(cbo_country) = "" Then
                SendMessage 8, "Value must be filled in", gut_LangLogin.Code
                cbo_country.SetFocus
                Exit Function
            End If
            
            If cbo_postCode.Text = "" Then
                SendMessage 8, "Value must be filled in", gut_LangLogin.Code
                cbo_postCode.SetFocus
                Exit Function
            End If
        End If
    End If
    
    Control = OK
    Exit Function
ErrHandler:
    Call ErrorHandler("Control")
End Function

Private Sub Customer_constants()
On Error GoTo ErrHandler

Dim ll_Cursor As Long
Dim ls_Text As String
    
    ll_Cursor = OpenSQLSafe(mo_Db, "EXEC Screen_Csts 'mtnc_DC_Customer' , " & SqlStr(ms_Language_Code, 1))

    Do While Not mo_Db.EOF(ll_Cursor)

        ls_Text = mo_Db.GetFields(ll_Cursor, "local_text")
        Select Case mo_Db.GetFields(ll_Cursor, "field_name")
            Case "title": ms_Title = ls_Text
            Case "titleA": ms_titleA = ls_Text
            Case "titleU": ms_titleU = ls_Text
            Case "titleD": ms_titleD = ls_Text
            Case "lbl_ShipFromDC": lbl_ShipFromDC = ls_Text
            Case "lbl_ShipDate": lbl_ShipDate = ls_Text
            Case "lbl_CarrierCpy": lbl_CarrierCpy = ls_Text
            Case "lbl_Equipement": lbl_Equipement = ls_Text
            Case "lbl_CustName": lbl_CustName = ls_Text
            Case "lbl_ShipAdd": lbl_ShipAdd = ls_Text
            Case "lbl_CLSOrderNb": lbl_CLSOrderNb = ls_Text
            Case "lbl_CLSShipNb": lbl_CLSShipNb = ls_Text
            Case "lbl_DeliveryDate": Lbl_DeliveryDate = ls_Text
            Case "lbl_QuantityWeight": lbl_QuantityWeight = ls_Text
            Case "lbl_RealQuantity": lbl_RealQuantity = ls_Text
            Case "lbl_UOM": lbl_UOM = ls_Text
            Case "lbl_COSContact": lbl_COSContact = ls_Text
            Case "lbl_RSRequire": lbl_RSRequire = ls_Text
            Case "Fr_Schedule": Fr_Schedule.Caption = ls_Text
            Case "lbl_HaulierBookNb": lbl_HaulierBookNb = ls_Text
            Case "lbl_StandTrailers": lbl_StandTrailers = ls_Text
            Case "lbl_LoadPlanStartTim": lbl_LoadPlanStartTime = ls_Text
            Case "lbl_LoadPlanEndTime": lbl_LoadPlanEndTime = ls_Text
            Case "Fr_Actual": Fr_Actual.Caption = ls_Text
            Case "lbl_ArrivalTime": lbl_ArrivalTime = ls_Text
            Case "lbl_TrailerNb": lbl_TrailerNb = ls_Text
            Case "lbl_LoadStartTime": lbl_LoadStartTime = ls_Text
            Case "lbl_LoadEndTime": lbl_LoadEndTime = ls_Text
            Case "lbl_LoadBy": lbl_LoadBy = ls_Text
            
            Case "lbl_paidByCustomer": lbl_paidByCustomer = ls_Text
            Case "lbl_masterTran": lbl_masterTran = ls_Text
            Case "lbl_transactionOrder": lbl_transactionOrder = ls_Text
            Case "lbl_CLSDeliveryNb": lbl_CLSDeliveryNb = ls_Text
            Case "lbl_totalQty": lbl_totalQty = ls_Text
            Case "lbl_totalCost": lbl_totalCost = ls_Text
            Case "lbl_country": lbl_Country = ls_Text
            Case "lbl_postCode": lbl_postCode = ls_Text
            Case "chk_manualPrice": chk_manualPrice.Caption = ls_Text
            Case "lbl_RealQuantity": lbl_RealQuantity = ls_Text
            Case "lbl_pallets": lbl_pallets.Caption = ls_Text
        End Select
        
        Call mo_Db.Next(ll_Cursor)
    Loop
    
    Call mo_Db.Close(ll_Cursor)

    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    ErrorHandler ("Customer_constants")
End Sub

Private Function Add_Table() As Boolean
Const C_REQ As String = "EXEC DC_Customer_ins $TRANS_code$,$DC_CARRIER_Code$,$TRANS_Date$,$MASTER_TRANS_code$,$TRANS_Order$,$Supplier_Name$,$EQ_code$,$CUSTN1$,$Ship_To_CT_Code$,$Ship_To_Zip_Code$,$Ship_To_Address$,$Order_Number$,$Shipment_Number$,$Delivery_Number$,$Delivery_Date$,$Quantity$,$Quantity_loaded$,$UOM_code$,$Palletes$,$Stand_Trailer$,$COS_Contact$,$Remark$,$Haulier_Booking_Number$,$Load_Planned_Starting_Time$,$Load_Planned_Ending_Time$,$Load_Arrival_Time$,$Trailer_Number$,$Load_Starting_Time$,$Load_Ending_Time$,$Load_By$,$CUST_Freight_Cost$,$CUST_FC_Currency$,$Receiving_DC$"
    Dim ls_req As String

On Error GoTo ErrHandler

    Dim lb_InTran As Boolean
    lb_InTran = False
    
    Add_Table = KO
    
    If Control Then
        If ControlOver Then
            Dim ls_newID As String
            
            ls_newID = mo_Db.SQLNextID("TRANS_code")
            If ls_newID = "" Then
                Call Err.Raise(1, "SQLNextID", "Missing definition for new ID:TRANS_code")
            End If
            
            ml_d = Val(ls_newID)
            
            Dim ll_i As Long
            For ll_i = LBound(moa_DCTransport_cost) To UBound(moa_DCTransport_cost)
                If moa_DCTransport_cost(ll_i).TRANS_Code = 0 Then
                    moa_DCTransport_cost(ll_i).TRANS_Code = ml_d
                    Exit For
                End If
            Next
            
            ls_req = Replace(C_REQ, "$TRANS_code$", ml_d, , , vbTextCompare)
            Call Item_ReplacePlaceholders(ls_req)
            
            Call BeginTran("DC_TRANSACTION")
            lb_InTran = True
            
            Call ExecuteSQLSafe(mo_Db, ls_req, 1)
            
            ' add surcharge link
            Call SaveCkvSurcharges(ml_d)
            
            DCCost1.TransCode = ml_d
            DCCost1.GridSave
            
            Call UpdateTransportCost(ml_d)
            
            If ms_TableName = "DC_Customer" Then    ' for ending do not propagate
                If GetCboKey(cbo_masterTran) <> "" Then
                    Call PropagateMasterTransData(ml_d)
                End If
            End If

            Call CommitTran("DC_TRANSACTION")
            lb_InTran = False
            
            Call ReorderTransaction(Val(GetCboKey(cbo_masterTran)), Val(txt_tranOrder.Text))

            RaiseEvent RowAdded(Array(ml_d, ml_d & "/" & txt_tranOrder.Text, "", IIf(GetCboKey(cbo_masterTran) = CStr(ml_d), 1, 0), 1, 1, FormatTime(txt_LoadPlanStartTime.Text), txt_CustName.Text, txt_DeliveryDate.Text, GetCboKey(cbo_country), txt_ShipAdd.Text, txt_QuantityWeight.Text, txt_CLSShipNb.Text, GetCboKey(cbo_carrier), GetCboValue(cbo_carrier, "CARRIER_Name"), txt_RSRequire.Text, DCCost1.Cost_Comment))
            Add_Table = OK
            
        End If
    End If
    
Exit Function

ErrHandler:
    If lb_InTran Then
        Call RollbackTran("DC_TRANSACTION")
        lb_InTran = False
    End If
    Call ErrorHandler("Add_Table")
End Function

Private Function Dlt_Table() As Boolean

Const C_REQ As String = "EXEC DC_Customer_del $TRANS_code$,$iConc$"
Const C_REQ_SURCHARGE_DEL As String = "EXEC DC_Tran_Surcharge_del $TRANS_code$"

On Error GoTo ErrHandler
    Dim ls_req As String
    Dim lb_InTran As Boolean
    Dim ll_Cursor As Long
    
    lb_InTran = False
    Dlt_Table = KO

    Call LockScreen(False)
    If SendMessage(5, "Delete record ?", gut_LangLogin.Code, vbQuestion + vbYesNo, "Delete ") = vbYes Then
        Call LockScreen(True)
        
        ' check if the transaction is master and if there is some other transaction linked
        Debug.Assert (GetCboKey(cbo_masterTran) <> "")
        
        If CStr(ml_d) = GetCboKey(cbo_masterTran) Then
            ' this is master transaction
            
            Dim ll_Count As Long
            
            ll_Cursor = OpenSQLSafe(mo_Db, "SELECT COUNT(TRANS_Code) AS transCount FROM DC_Transaction WHERE Master_TRANS_Code=" & SQLNum(ml_d))
            ll_Count = mo_Db.GetFields(ll_Cursor, "transCount")
            
            Call mo_Db.Close(ll_Cursor)
            ll_Cursor = 0
            
            If ll_Count >= 2 Then
                ReDim ms_MsgInfo(0, 1)
                ms_MsgInfo(0, 0) = "$TRAN_COUNT$"
                ms_MsgInfo(0, 1) = ll_Count - 1
                Call MsgBox(MsgText(5090, ms_Language_Code, "#Master transaction cannot be deleted when linked transaction exists : $TRAN_COUNT$", ms_MsgInfo), vbCritical Or vbOKOnly)
                Exit Function
            End If
            
        End If
        
        txt_QuantityWeight.Text = "0"
        mb_synchLoadedQty = True
        
        mb_eventRunning = False
        Dim lb_cancel As Boolean
        lb_cancel = False
        Call txt_QuantityWeight_Validate(lb_cancel)
        Debug.Assert (Not lb_cancel)
        mb_eventRunning = True
        
        Dim ll_CurrentLine As Long
        ll_CurrentLine = GetDCTransportLine(ml_d)
        
        moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Price = 0       ' to supress current line from GetMostExpensive
        
        Call BeginTran("DC_TRANSACTION")
        lb_InTran = True
        
        DCCost1.GridDelete
        
        ls_req = Replace(C_REQ, "$TRANS_code$", SQLNum(ml_d), , , vbTextCompare)
        ls_req = Replace(ls_req, "$iConc$", SQLNum(ml_iConcurrency), , , vbTextCompare)
        
        Call ExecuteSQLSafe(mo_Db, ls_req, 1)
        
        Call ExecuteSQLSafe(mo_Db, Replace(C_REQ_SURCHARGE_DEL, "$TRANS_code$", SQLNum(ml_d), , , vbTextCompare))
        
        Call UpdateTransportCost(ml_d)
        
        Call CommitTran("DC_TRANSACTION")
        lb_InTran = False
        
        Call ReorderTransaction(Val(GetCboKey(cbo_masterTran)), Val(txt_tranOrder.Text))
        
        RaiseEvent RowDeleted(Array(ml_d))
        Dlt_Table = OK
    Else
        Call LockScreen(True)
    End If
    Exit Function
ErrHandler:
    Call LockScreen(False)
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    If lb_InTran Then
        Call RollbackTran("DC_TRANSACTION")
        lb_InTran = False
    End If

    Call ErrorHandler("Dlt_Table")
End Function

Private Function Upd_Table() As Boolean
Const C_REQ As String = "EXEC DC_Customer_upd $TRANS_code$,$iConc$,$DC_CARRIER_Code$,$TRANS_Date$,$MASTER_TRANS_code$,$TRANS_Order$,$Supplier_Name$,$EQ_code$,$CUSTN1$,$Ship_To_CT_Code$,$Ship_To_Zip_Code$,$Ship_To_Address$,$Order_Number$,$Shipment_Number$,$Delivery_Number$,$Delivery_Date$,$Quantity$,$Quantity_loaded$,$UOM_code$,$Palletes$,$Stand_Trailer$,$COS_Contact$,$Remark$,$Haulier_Booking_Number$,$Load_Planned_Starting_Time$,$Load_Planned_Ending_Time$,$Load_Arrival_Time$,$Trailer_Number$,$Load_Starting_Time$,$Load_Ending_Time$,$Load_By$,$CUST_Freight_Cost$,$CUST_FC_Currency$,$Receiving_DC$"
Const C_REQ_END As String = "EXEC DC_Cust_End_upd $TRANS_code$,$iConc$,$Stand_Trailer$,$Haulier_Booking_Number$,$Load_Planned_Starting_Time$,$Load_Planned_Ending_Time$,$Load_Arrival_Time$,$Trailer_Number$,$Load_Starting_Time$,$Load_Ending_Time$,$Load_By$,$Quantity_loaded$,$Palletes$"

On Error GoTo ErrHandler
    
    Dim ls_req As String
    Dim lb_InTran As Boolean
    Dim lb_updatePreviousMasterTran As Boolean
    Dim ll_prevMasterDCPL_Code As Long
'    Dim ls_prevMasterCURR_code As String
    Dim ld_prevMasterDropOff_Cost As Double
    Dim ls_prevMasterFullTruckCalculation As String
    Dim ll_Cursor As Long
    
    lb_InTran = False
    lb_updatePreviousMasterTran = False
    Upd_Table = KO


    If Control Then
    If ControlOver Then
        If ms_TableName = "DC_Customer" Then
            ls_req = Replace(C_REQ, "$TRANS_code$", SQLNum(ml_d), , , vbTextCompare)
            ls_req = Replace(ls_req, "$iConc$", SQLNum(ml_iConcurrency), , , vbTextCompare)
            Call Item_ReplacePlaceholders(ls_req)
            
            If ml_prevMasterTran <> Val(GetCboKey(cbo_masterTran)) And ml_prevMasterTran <> ml_d Then
                
                ' if we changed the master transaction and
                ' this is not master transaction (= last transaction) and
                ' new master transaction is not this (= generate new master transaction)
                ' then
                ' we have to update also the cost for previous master transaction
                
                ll_Cursor = OpenSQLSafe(mo_Db, "EXEC DC_PriceListTran_sel " & SQLNum(ml_prevMasterTran))
                
                If Not mo_Db.EOF(ll_Cursor) Then
                    ll_prevMasterDCPL_Code = mo_Db.GetFields(ll_Cursor, "DCPL_Code")
                    ld_prevMasterDropOff_Cost = mo_Db.GetFields(ll_Cursor, "DropOff_Cost")
                    ls_prevMasterFullTruckCalculation = mo_Db.GetFields(ll_Cursor, "FullTruckCalculation")
                    
                    lb_updatePreviousMasterTran = True
                End If
                
                Call mo_Db.Close(ll_Cursor)
                ll_Cursor = 0
            End If
        
        ElseIf ms_TableName = "DC_Cust_End" Then
            
            ls_req = Replace(C_REQ_END, "$TRANS_code$", SQLNum(ml_d), , , vbTextCompare)
            ls_req = Replace(ls_req, "$iConc$", SQLNum(ml_iConcurrency), , , vbTextCompare)
            Call Item_ReplacePlaceholders(ls_req)
        
        End If
        
        
        Call BeginTran("DC_TRANSACTION")
        lb_InTran = True
        
        Call ExecuteSQLSafe(mo_Db, ls_req, 1)
        
        ' manage surcharge link
        Call SaveCkvSurcharges(ml_d)
        
        DCCost1.GridSave
        
        Call UpdateTransportCost(ml_d)
        
        If lb_updatePreviousMasterTran Then
        
            Call InitTransportCost(-1, ml_prevMasterTran, ll_prevMasterDCPL_Code)
            
            Call UpdateTransportCost_all(ld_prevMasterDropOff_Cost, ls_prevMasterFullTruckCalculation)
            
        End If
        
        If ms_TableName = "DC_Customer" Then    ' for ending do not propagate
            If GetCboKey(cbo_masterTran) <> "" Then
                Call PropagateMasterTransData(ml_d)
            End If
        End If

        Call CommitTran("DC_TRANSACTION")
        lb_InTran = False
        
        Call ReorderTransaction(Val(GetCboKey(cbo_masterTran)), Val(txt_tranOrder.Text))
        
        If ml_prevMasterTran <> Val(GetCboKey(cbo_masterTran)) Then
            Call ReorderTransaction(ml_prevMasterTran, IIf(ml_prevMasterTran = ml_d, 1, -1))
        End If
        
        RaiseEvent RowUpdated(Array(ml_d, ml_d & "/" & txt_tranOrder.Text, "", IIf(GetCboKey(cbo_masterTran) = CStr(ml_d), 1, 0), 1, 1, FormatTime(txt_LoadPlanStartTime.Text), txt_CustName.Text, txt_DeliveryDate.Text, GetCboKey(cbo_country), txt_ShipAdd.Text, txt_QuantityWeight.Text, txt_CLSShipNb.Text, GetCboKey(cbo_carrier), GetCboValue(cbo_carrier, "CARRIER_Name"), txt_RSRequire.Text, DCCost1.Cost_Comment))
        Upd_Table = OK
    End If
    End If
    Exit Function

ErrHandler:
    If lb_InTran Then
        Call RollbackTran("DC_TRANSACTION")
        lb_InTran = False
    End If
    
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler("Upd_Table")
End Function

Private Sub PropagateMasterTransData(ByVal al_masterTrans As Long)
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC DC_MasterTrans_upd2 $MASTER_TRANS_code$"
    Call ExecuteSQLSafe(mo_Db, Replace(C_REQ, "$MASTER_TRANS_code$", SQLNum(al_masterTrans)))
    Exit Sub
ErrHandler:
    Call ErrorHandler("PropagateMasterTransData")
End Sub


Private Sub ReorderTransaction(ByVal al_masterTran As Long, ByVal al_currentTranOrder As Long)
On Error GoTo ErrHandler
    Dim ll_Cursor As Long
    Dim ls_req As String
    
    If al_masterTran = 0 Then Exit Sub
    
    ' out of databae transaction we reorder the lines on the truck to keep current TRANS_Order as it is

Const C_TRAN_REQ_LST As String = "SELECT TRANS_Code, TRANS_Order FROM DC_Transaction WHERE Master_TRANS_Code=$MASTER_TRANS_code$ ORDER BY TRANS_Order, Z_last_upd DESC"
Const C_TRAN_REQ_UPD As String = "EXEC DC_Transaction_OrderUpd $TRANS_code$, $TRANS_Order$"
Const C_TRAN_REQ_UPD_MASTER As String = "EXEC DC_Transaction_MasterUpd $MASTER_TRANS_code$, $NEW_MASTER_TRANS_code$"
    
    ls_req = Replace(C_TRAN_REQ_LST, "$MASTER_TRANS_code$", SQLNum(al_masterTran), , , vbTextCompare)
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    
    Dim ll_correctOrder As Long
    ll_correctOrder = 1
    
    Dim ll_newMasterTran As Long
    ll_newMasterTran = 0
    
    While Not mo_Db.EOF(ll_Cursor)
        If ll_correctOrder <> mo_Db.GetFields(ll_Cursor, "TRANS_Order") Then
        
            ' if order to put is the same as our transaction we move to next
            If ll_correctOrder = al_currentTranOrder Then
                ll_correctOrder = ll_correctOrder + 1
            End If
            
            ' correct order if it is not current transaction
            If mo_Db.GetFields(ll_Cursor, "TRANS_Code") <> ml_d Then
                ls_req = Replace(C_TRAN_REQ_UPD, "$TRANS_code$", SQLNum(mo_Db.GetFields(ll_Cursor, "TRANS_Code")), , , vbTextCompare)
                ls_req = Replace(ls_req, "$TRANS_Order$", SQLNum(ll_correctOrder), , , vbTextCompare)
            
                Call ExecuteSQLSafe(mo_Db, ls_req)
                
                ' if we are updating first transaction in the truck -> it will become master
                If ll_correctOrder = 1 Then
                    ll_newMasterTran = mo_Db.GetFields(ll_Cursor, "TRANS_Code")
                End If
                
                ll_correctOrder = ll_correctOrder + 1
            End If
        Else
            If ll_correctOrder = 1 And al_currentTranOrder = 1 Then
                ll_newMasterTran = mo_Db.GetFields(ll_Cursor, "TRANS_Code")
            End If
            ll_correctOrder = ll_correctOrder + 1
        End If
    
        Call mo_Db.Next(ll_Cursor)
    Wend
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    If ll_newMasterTran <> 0 Then
        ' record new master transaction
        If Val(GetCboKey(cbo_masterTran)) <> ll_newMasterTran Then
            ls_req = Replace(C_TRAN_REQ_UPD_MASTER, "$MASTER_TRANS_code$", SQLNum(al_masterTran), , , vbTextCompare)
            ls_req = Replace(ls_req, "$NEW_MASTER_TRANS_code$", SQLNum(ll_newMasterTran), , , vbTextCompare)
            ls_req = Item_ReplacePlaceholders(ls_req)
            Call ExecuteSQLSafe(mo_Db, ls_req)
        End If
    End If

    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler("ReorderTransaction")
End Sub

Private Function DateFormat(datedeb As String) As String

If Len(datedeb) = 5 Then
    DateFormat = Left(datedeb, 2) + right(datedeb, 2)
Else
    DateFormat = datedeb
End If

End Function

Private Sub Item_Load(ByVal al_TRANS_Code As Long)
Dim ll_Cursor As Long

On Error GoTo ErrHandler
    ml_d = al_TRANS_Code
    mb_synchLoadedQty = True
    
    If al_TRANS_Code = 0 Then
        md_manualCost = 0
        ml_prevMasterTran = 0
        chk_manualPrice.Value = vbUnchecked

        txt_ShipFromDC = ms_DC_Name
        txt_ShipDate = DateToString(md_shippingDay)
        AddDay
        txt_LoadPlanStartTime = "0000"
        txt_LoadPlanEndTime = "0000"
        txt_LoadStartTime = "0000"
        txt_LoadEndTime = "0000"
        txt_ArrivalTime = "0000"
        txt_tranOrder = "1"
        txt_paidByCustomer = "0"
        txt_RealQuantity = "0"

        ' default currency based on market of a user
        ll_Cursor = OpenSQLSafe(mo_Db, "EXEC currencies_sel1 '" & ms_LoginName & "','" & ms_Language_Code & "'")
            Call SetComboItemValue(cbo_currency, mo_Db.GetFields(ll_Cursor, "curr_code"))
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0

        DCCost1.TransCode = 0
        
        Call RefreshMasterTran(False)
        Call RefreshCTInfo(False)
    Else

        ll_Cursor = OpenSQLSafe(mo_Db, "EXEC Dc_Customer_dtl " & al_TRANS_Code)
        
        ' global vars
        DC_Code = mo_Db.GetFields(ll_Cursor, "DC_Code")
        DC_name = mo_Db.GetFields(ll_Cursor, "Supplier_Name")
        ShippingDay = mo_Db.GetFields(ll_Cursor, "TRANS_Date")
        ml_iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")
        ml_prevMasterTran = mo_Db.GetFields(ll_Cursor, "Master_TRANS_Code")
        
        ' ui data
        txt_ShipFromDC.Text = ms_DC_Name
        txt_ShipDate.Text = DateToString(md_shippingDay)
        Call SetComboItemValue(cbo_carrier, mo_Db.GetFields(ll_Cursor, "CARRIER_Code"))

        chk_manualPrice.Value = vbUnchecked
        
        Call RefreshMasterTran(False)
        Call RefreshCTInfo(False)
        
        If mo_Db.GetFields(ll_Cursor, "Ship_To_CT_Code") <> "" Then
            If Not SetComboItemValue(cbo_country, mo_Db.GetFields(ll_Cursor, "Ship_To_CT_Code")) Then
                ' country not found with the support of pricelist
                chk_manualPrice.Value = vbChecked
                Call RefreshCTInfo(False)
                If Not SetComboItemValue(cbo_country, mo_Db.GetFields(ll_Cursor, "Ship_To_CT_Code")) Then
                    Call MsgBox(MsgText(5100, ms_Language_Code, "#Difficulties to load the country!"), vbInformation Or vbOKOnly)
                End If
            End If
        End If
        
        Call SetComboItemValue(cbo_Equipement, mo_Db.GetFields(ll_Cursor, "EQ_code"))
        If Not SetComboItemValue(cbo_UOM, mo_Db.GetFields(ll_Cursor, "UOM_Code")) And chk_manualPrice.Value = vbUnchecked Then
            ' UOM not found with the support of pricelist
            chk_manualPrice.Value = vbChecked
            Call RefreshCTInfo(True)
            If Not SetComboItemValue(cbo_UOM, mo_Db.GetFields(ll_Cursor, "UOM_Code")) Then
                 Call MsgBox(MsgText(5101, ms_Language_Code, "#Difficulties to load the UOM!"), vbInformation Or vbOKOnly)
            End If
        End If
        
        Call SetComboItemValue(cbo_currency, mo_Db.GetFields(ll_Cursor, "CUST_FC_Currency"))
        
        Call RefreshZIPInfo(False)
        cbo_postCode.Text = mo_Db.GetFields(ll_Cursor, "Ship_To_Zip_Code")
        
        
        Call SetComboItemValue(cbo_masterTran, mo_Db.GetFields(ll_Cursor, "Master_TRANS_Code"))
        
        txt_CustName.Text = mo_Db.GetFields(ll_Cursor, "CUSTN1")
        txt_ShipAdd = mo_Db.GetFields(ll_Cursor, "Ship_To_Address")
        txt_CLSOrderNb = mo_Db.GetFields(ll_Cursor, "Order_Number")
        txt_CLSShipNb = mo_Db.GetFields(ll_Cursor, "Shipment_Number")
        cbo_delivery.Text = mo_Db.GetFields(ll_Cursor, "Delivery_Number")
        txt_DeliveryDate = DateToString(mo_Db.GetFields(ll_Cursor, "Delivery_Date"))
        txt_QuantityWeight = mo_Db.GetFields(ll_Cursor, "Quantity")
        txt_RealQuantity = mo_Db.GetFields(ll_Cursor, "Quantity_loaded")
        txt_palletes.Text = mo_Db.GetFields(ll_Cursor, "Palletes")
        chk_isReturn.Value = IIf(mo_Db.GetFields(ll_Cursor, "Receiving_DC") = "", vbUnchecked, vbChecked)
        
        Call RefreshSurchargeInfo(False)    ' call after delivery date set
'        Call SetComboItemValue(cbo_surcharges, mo_Db.GetFields(ll_Cursor, "DCS_Code"))
        
        If mo_Db.GetFields(ll_Cursor, "Stand_Trailer") = "Y" Then
            Opt_Yes.Value = OK
        Else
            Opt_No.Value = OK
        End If
        txt_COSContact = mo_Db.GetFields(ll_Cursor, "COS_Contact")
        txt_RSRequire = mo_Db.GetFields(ll_Cursor, "remark")
        txt_HaulierBookNb = mo_Db.GetFields(ll_Cursor, "Haulier_Booking_Number")
        txt_LoadPlanStartTime = mo_Db.GetFields(ll_Cursor, "Load_Planned_Starting_Time")
        txt_LoadPlanEndTime = mo_Db.GetFields(ll_Cursor, "Load_Planned_Ending_Time")
        txt_ArrivalTime = mo_Db.GetFields(ll_Cursor, "Load_Arrival_Time")
        txt_TrailerNb = mo_Db.GetFields(ll_Cursor, "Trailer_Number")
        txt_LoadStartTime = mo_Db.GetFields(ll_Cursor, "Load_Starting_Time")
        txt_LoadEndTime = mo_Db.GetFields(ll_Cursor, "Load_Ending_Time")
        txt_LoadBy = mo_Db.GetFields(ll_Cursor, "Load_By")
        txt_tranOrder.Text = mo_Db.GetFields(ll_Cursor, "TRANS_Order")
        txt_paidByCustomer.Text = mo_Db.GetFields(ll_Cursor, "CUST_Freight_Cost")
        txt_totalCost.Text = Format(mo_Db.GetFields(ll_Cursor, "Total_Cost"), "###0.00")
        md_manualCost = mo_Db.GetFields(ll_Cursor, "Total_Cost_Manual")
        
        If al_TRANS_Code = mo_Db.GetFields(ll_Cursor, "Master_TRANS_Code") Then
            ' we are editing the master transaction that is inUse
            If Val(GetCboValue(cbo_masterTran, "InUse")) > 0 Then
                cbo_masterTran.Enabled = False
            End If
        End If
        
        If mo_Db.GetFields(ll_Cursor, "Quantity") <> mo_Db.GetFields(ll_Cursor, "Quantity_loaded") Then
            mb_synchLoadedQty = False
        End If
        
        Call mo_Db.Close(ll_Cursor)
        
        DCCost1.TransCode = al_TRANS_Code
    End If
    
    Call DCCost1.Grid_Init
    
    Call UpdatePriceListUI
    
    Call UpdateMasterTransUI
    
    Call InitTransportCost(ml_d, Val(GetCboKey(cbo_masterTran)), Val(GetCboValue(cbo_UOM, "DCPL_Code")))
    
    Dim lb_isFullTruck As Boolean
    Dim lb_isFullTruckCost As Boolean
    Dim lb_overLoaded As Boolean
    Dim lb_overLoadedCost As Boolean
    Dim lb_mixedUOM As Boolean
    Dim lb_isTrailer As Boolean

    Call CheckTransportCost(Val(GetCboValue(cbo_UOM, "DropOff_Cost", "0")), GetCboValue(cbo_UOM, "FullTruckCalculation", "Y"), lb_isFullTruck, lb_overLoaded, lb_overLoadedCost, lb_mixedUOM, lb_isFullTruckCost, lb_isTrailer)

    If lb_isTrailer And GetCboKey(cbo_country) <> "" And Trim(cbo_postCode.Text) <> "" Then
        ' have to go into database for specific trailer cost

        Dim ll_mostExpensiveLine As Long
        ll_mostExpensiveLine = GetMostExpensiveTransportLine()

        Dim ld_qtyCost As Double
        ld_qtyCost = GetTotalQty(QTY_FOR_COST)
    
        Call UpdatePriceTrailer(moa_DCTransport_cost(ll_mostExpensiveLine), ld_qtyCost, GetCboKey(cbo_country), cbo_postCode.Text)
    End If

    
    If txt_totalCost.Text <> "" Then
    
        Dim ld_TotalQty As Double
        ld_TotalQty = GetTotalQty(QTY_FOR_TRANSPORT)
        
        Dim ll_CurrentLine As Long
        ll_CurrentLine = GetDCTransportLine(ml_d)
        If moa_DCTransport_cost(ll_CurrentLine).DCPLL_Trailer_min > ld_TotalQty Then
            
            Call PropagateTotalQty(ld_TotalQty, 0, GetTotalQty(QTY_FOR_COST), GetTotalCost(lb_isFullTruckCost, Val(GetCboValue(cbo_UOM, "DropOff_Cost")), md_manualCost, False))
        Else
            
            Call PropagateTotalQty(ld_TotalQty, moa_DCTransport_cost(ll_CurrentLine).DCPLL_Trailer_min, GetTotalQty(QTY_FOR_COST), GetTotalCost(lb_isFullTruckCost, Val(GetCboValue(cbo_UOM, "DropOff_Cost")), md_manualCost, False))
        End If
    End If
    

    Exit Sub

ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
    End If
    Call ErrorHandler("Item_load")
End Sub

Private Sub PropagateTotalQty(ByVal al_totalQty As Double, ByVal al_trailerMin As Double, ByVal al_totalQtyCost As Double, ByVal ad_totalCost As Double)
On Error GoTo ErrHandler

    If al_trailerMin = 0 Then
        txt_totalQty.Text = al_totalQty
    Else
        txt_totalQty.Text = (al_trailerMin - 1) & "+" & (al_totalQty - al_trailerMin + 1)
    End If
    
    If al_totalQtyCost <> 0 Then
        DCCost1.PartialCost = (GetCurrentQty(QTY_FOR_COST) / al_totalQtyCost) * (ad_totalCost - md_manualCost) + DCCost1.SurchargeCost
    Else
        DCCost1.PartialCost = DCCost1.SurchargeCost
    End If
    
    Exit Sub

ErrHandler:
    Call ErrorHandler("PropagateTotalQty")
End Sub

Private Sub Item_Clear()
On Error GoTo ErrHandler
    Dim lo_Control As Control
    For Each lo_Control In Controls
        If lo_Control.Tag <> "" Then
            Select Case UCase(TypeName(lo_Control))
            Case "ARMCOMBOBOX"
                Call lo_Control.Clear
            Case "COMBOBOX"
                Call lo_Control.Clear
            Case "ARMPICKER"
            Case "TOOLBARCONTROL"
            Case "ARMGRID"
            Case "ARMTREEVIEW"
            Case "ARMCHECKVIEW"
            Case "A_CALOCX"
            Case "TOOLBR"
            Case "TEXTBOX"
                lo_Control.Text = ""
            Case "CHECKBOX"
                lo_Control.Value = vbUnchecked
            End Select
        End If
    Next
    
    Opt_No.Value = True
      
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Clear()")
End Sub

' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, Me.Name & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

' logs message to database
#If LIVE = 1 Then
    Public Sub LogMessage(ByVal ao_Db As Object, ByVal al_U_Code As Long, ByVal as_ScreenName As String, ByVal as_LogMsg As String, Optional ByVal as_LogType As String = "E", Optional ByVal ab_ExitOnException As Boolean = True)
#Else
    Public Sub LogMessage(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal al_U_Code As Long, ByVal as_ScreenName As String, ByVal as_LogMsg As String, Optional ByVal as_LogType As String = "E", Optional ByVal ab_ExitOnException As Boolean = True)
#End If
On Error GoTo ErrHandler
    
Const LOG_REQUEST As String = "EXEC A_log_ins $UCODE$,$LOGTYPE$,$MSG$,$APP$"
    
Dim ls_req As String
Dim ll_Cursor As Long
Dim ls_Source As String, ls_Msg As String
  
  ls_Source = as_ScreenName & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
  
  ls_req = Replace(LOG_REQUEST, "$UCODE$", SQLNum(al_U_Code), , , vbTextCompare)
  ls_req = Replace(ls_req, "$LOGTYPE$", SqlStr(as_LogType), , , vbTextCompare)
  ls_req = Replace(ls_req, "$MSG$", SqlStr(Trim(as_LogMsg), 4000), , , vbTextCompare)
  ls_req = Replace(ls_req, "$APP$", SqlStr(Trim(ls_Source), 50), , , vbTextCompare)
  
  Call ExecuteSQLSafe(ao_Db, ls_req)
  Exit Sub
ErrHandler:
  If ab_ExitOnException Then
    Call MsgBox("A fatal error occured. Unable to log error into database, the application will be closed. Please report the following message to your IT support: " & vbCrLf & _
      as_LogMsg & " - " & ls_Source & "LogMessage exception " & Err.Number & "-" & Err.Description, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
  Else
    Call ao_Db.Disconnect
  End If
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetDbError()")
End Function

Public Sub Load_A_COM()
    
On Error GoTo ErrHandler

    If mb_Initialized Then Exit Sub
    
    mb_Initialized = True
    
    mb_eventRunning = True
    
    Dim lo_Control As Object
    
      For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW0"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        End Select
      Next
    
    If gl_CodePage <> 1252 And gl_CodePage <> 0 Then ChangeCharset Me

#If LIVE = 1 Then
    Set mo_Sys = CreateObject("ArmSYSCOM.ArmSys")
    Set mo_sapXML = CreateObject("MSXML2.DOMDocument")
    Set mo_scriptObj = CreateObject("MSScriptControl.ScriptControl")
#Else
    Set mo_Sys = New ARMSYSCOMLib.ArmSYS
    Set mo_sapXML = New MSXML2.DOMDocument
    Set mo_scriptObj = New MSScriptControl.ScriptControl
#End If

    mo_scriptObj.Language = "VBScript"
    
    spp_save.Picture = LoadResPicture(RES_OK, vbResIcon)
    ssp_quit.Picture = LoadResPicture(RES_QUIT, vbResIcon)
    btn_OK2.Picture = LoadResPicture(RES_AND, vbResIcon)
    SSShipDate.Picture = LoadResPicture(RES_DOWN2, vbResIcon)
    SSDeliveryDate.Picture = LoadResPicture(RES_DOWN2, vbResIcon)

    If Not mo_Db.IsConnected Then
        Call ReconnectSafe
    End If
    
    DCCost1.dc_user = ms_LoginName
    Set DCCost1.ArmDb = mo_Db
    Call DCCost1.SetReconnectParams(ms_reconnectServer, ms_reconnectDB, ms_reconnectUser, ms_reconnectPassword, ms_reconnectApp)
    DCCost1.Lang = ms_Language_Code
    DCCost1.U_Code = ml_U_Code
    Call DCCost1.Load_A_COM

    
    ckv_surcharges.Columns = 8  ' Checked,DCS_Price, DCPLL_Code, UOM_Code, DCS_Default, DCS_Formula, DCS_quantity
    
    ckv_surcharges.HeaderSizes = Array(3000, 0, 0, 0, 0, 0, 0, 0)
    

    Call Customer_constants
    
    cbo_carrier.FirstBlankItem = False
    cbo_country.FirstBlankItem = False
    cbo_masterTran.FirstBlankItem = True
    
    cbo_currency.FirstBlankItem = True
    cbo_currency.Request = "EXEC DC_currencies_cbo " & SqlStr(ms_Language_Code, 1)
    
    cbo_Equipement.FirstBlankItem = False
    cbo_Equipement.Request = "EXEC DC_Equipement_cbo"
    
    cbo_UOM.FirstBlankItem = False
    cbo_UOM.Request = "EXEC DC_UOM_cbo2"
    
    mb_eventRunning = False
    
    Exit Sub
    
ErrHandler:
    
    ' called from outside of the form
    Call ErrorMessage("Load_A_COM")
    
End Sub

Public Sub InitControl()
On Error GoTo ErrHandler
    mb_eventRunning = True
    
    Dim lsa_PLs() As String
    lsa_PLs = Split(Get_A_Config("DC_PL_STYLE"), SEP)
    
    Dim ll_i As Long
    mb_PL_STYLE_ENABLED = False
    For ll_i = LBound(lsa_PLs) To UBound(lsa_PLs)
        If lsa_PLs(ll_i) = ms_DC_Code Then
            mb_PL_STYLE_ENABLED = True
            Exit For
        End If
    Next
    
    ms_UrlWebService = Get_A_Config("DC_WEBSERVICE_ORDER_DATA")
    
    Call Item_Clear
    
    cbo_carrier.Request = "EXEC DC_Carrier_lst2 " & SqlStr(ms_DC_Code, 4) & ", 'C'," & SqlDate(md_shippingDay) & ", NULL"
    
    Call UpdateUI(gs_Action)
    
    If gs_Action = "Add" Then
        Caption = ms_Title & " - " & ms_titleA
    ElseIf gs_Action = "Update" Then
        Caption = ms_Title & " - " & ms_titleU
    ElseIf gs_Action = "Delete" Then
        Caption = ms_Title & " - " & ms_titleD
    Else
        Caption = ms_Title
    End If

    
    If gs_Action = "Add" Then
        Call Item_Load(0)
        DCCost1.Enabled = True
    Else
        Call Item_Load(ml_d)
        DCCost1.Enabled = (gs_Action = "Update")
    End If
    
    mb_eventRunning = False

    Exit Sub
ErrHandler:
    mb_eventRunning = False
    Call ErrorMessage("InitControl")
End Sub

Private Property Get SupportPriceList() As Boolean
On Error GoTo ErrHandler
    SupportPriceList = mb_PL_STYLE_ENABLED And Val(GetCboValue(cbo_carrier, "DCPL_Count")) > 0 And txt_ShipDate.Text <> ""
    Exit Property
ErrHandler:
    Call ErrorHandler("SupportPriceList()")
End Property

Private Sub UpdatePriceListUI()
On Error GoTo ErrHandler
    Dim lb_supportPL As Boolean
    lb_supportPL = SupportPriceList

    If lb_supportPL Or chk_manualPrice.Value = vbChecked Then
        ' OK we have a price list
        txt_CustName.Width = cbo_carrier.Width
        cbo_country.Visible = True
        lbl_Country.Visible = True
        
        cbo_postCode.Visible = True
        lbl_postCode.Visible = True
        
    Else
        ' no pricelist available
        txt_CustName.Width = txt_ShipAdd.Width
        cbo_country.Visible = False
        lbl_Country.Visible = False
        
        cbo_postCode.Visible = False
        lbl_postCode.Visible = False
        
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdatePriceListUI()")
End Sub

Private Sub UpdateMasterTransUI()
On Error GoTo ErrHandler
    If (gs_Action <> "Add" And gs_Action <> "Update") Or ms_TableName = "DC_Cust_End" Then Exit Sub
    
    If Val(GetCboKey(cbo_masterTran)) = ml_d Then
'        Call EnableControl(SSShipDate, True)
        Call EnableControl(cbo_carrier, True)
        Call EnableControl(cbo_Equipement, True)
    Else
'        Call EnableControl(SSShipDate, False)
        Call EnableControl(cbo_carrier, False)
        Call EnableControl(cbo_Equipement, False)
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateMasterTransUI()")
End Sub

Private Sub UpdateUI(ByVal as_Mode As String)
On Error GoTo ErrHandler
    Select Case as_Mode
        
        Case "Add"
            Call SetEnabled(GetContainedControlsChain(Me), True)
            Call EnableControl(txt_RealQuantity, False)
            Call EnableControl(txt_ShipFromDC, False)
            Call EnableControl(txt_totalCost, False)
            Call EnableControl(txt_totalQty, False)
            
            SSShipDate.Visible = False
            spp_save.Visible = True
            btn_OK2.Visible = True
        Case "Update"
            If ms_TableName = "DC_Cust_End" Then
                Call SetEnabled(GetContainedControlsChain(Me), False)
                Call SetEnabled(GetContainedControlsChain(Fr_Schedule), True)
                Call SetEnabled(GetContainedControlsChain(Fr_Actual), True)
                
                Call EnableControl(txt_RealQuantity, True)
                Call EnableControl(txt_palletes, True)
                Call EnableControl(spp_save, True)
                Call EnableControl(ssp_quit, True)
            Else
                Call SetEnabled(GetContainedControlsChain(Me), True)
                Call EnableControl(txt_RealQuantity, False)
                Call EnableControl(txt_ShipFromDC, False)
                Call EnableControl(txt_totalQty, False)
            End If
            Call EnableControl(txt_totalCost, False)
            
            SSShipDate.Visible = True
            spp_save.Visible = True
            btn_OK2.Visible = False
        Case "Delete"
            Call SetEnabled(GetContainedControlsChain(Me), False)
            SSShipDate.Visible = False
            spp_save.Visible = True
            btn_OK2.Visible = False
            Call EnableControl(spp_save, True)
            Call EnableControl(ssp_quit, True)
        Case "MoreInfo"
            Call SetEnabled(GetContainedControlsChain(Me), False)
            SSShipDate.Visible = False
            spp_save.Visible = False
            btn_OK2.Visible = False
            Call EnableControl(ssp_quit, True)
    End Select
    
    ' allways locked
    txt_ShipDate.Locked = True
    txt_DeliveryDate.Locked = True
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateUI()")
End Sub


Public Sub Unload_A_COM()
    
On Error GoTo ErrHandler
    mb_Initialized = False
    
    Dim lo_Control As Object

    For Each lo_Control In Controls
      Select Case UCase(TypeName(lo_Control))
      Case "ARMCOMBOBOX"
        Call lo_Control.Unload_A_COM
      Case "ARMPICKER"
        Call lo_Control.Unload_A_COM
      Case "TOOLBARCONTROL"
        Call lo_Control.Unload_A_COM
      Case "ARMGRID"
        Call lo_Control.Unload_A_COM
      Case "ARMTREEVIEW"
        Call lo_Control.Unload_A_COM
      Case "ARMCHECKVIEW"
        Call lo_Control.Unload_A_COM
      Case "TOOLBR"
        Call lo_Control.Unload_A_COM
      End Select
    Next
    
    Call DCCost1.Unload_A_COM
    
    Set mo_Sys = Nothing
    
    Set mo_scriptObj = Nothing
    
    Exit Sub
    
ErrHandler:
    
    Call ErrorHandler("UnLoad_A_Com")
    
End Sub


Private Function ReconnectSafe() As Boolean
On Error GoTo ErrHandler

    ReconnectSafe = False
    
    Dim ll_Counter As Long
    ll_Counter = 3              ' try 3 times to connect
    
    If IsLostConnection(mo_Db) Then
    
        Call mo_Db.Disconnect
        
        Do While ll_Counter > 0
        
            If mo_Db.Connect(ms_reconnectServer, ms_reconnectDB, ms_reconnectUser, ms_reconnectPassword, ms_reconnectApp) Then
                ReconnectSafe = True
                Exit Do
            End If
            
            ll_Counter = ll_Counter - 1
        Loop
        
    End If
    
    Exit Function
ErrHandler:
     Call ErrorHandler("ReconnectSafe()")
End Function

Private Function IsLostConnection(ByRef ao_Armdb As ArmDb) As Boolean
On Error GoTo ErrHandler
    
    IsLostConnection = Not ao_Armdb.IsConnected
    
    If IsArray(ao_Armdb.SQLErrorCodes) Then
        Dim lv_ErrCode As Variant
        Dim ll_Index As Long
        
        lv_ErrCode = ao_Armdb.SQLErrorCodes
        
        For ll_Index = LBound(lv_ErrCode) To UBound(lv_ErrCode)
            If lv_ErrCode(ll_Index) = 11 Then       '[DBNETLIB][ConnectionWrite (send()).]General network error. Check your network documentation.
                IsLostConnection = True
                Exit For
            End If
        Next

    End If
    
    Exit Function
ErrHandler:
     Call ErrorHandler("IsLostConnection()")
End Function


Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
On Error GoTo ErrHandler
    Dim lc_Data As Long
tryAgain:
    lc_Data = ao_Db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        
        MsgBox ("Execution failed")
        
        Dim ls_ErrMsg As String
        ls_ErrMsg = "SQL Error: " & GetDbError(ao_Db)
        
        If ReconnectSafe() Then
            GoTo tryAgain
        End If
        
        Call Err.Raise(1, "ao_Db.OpenSQL - " & "SQL : " & as_Request, ls_ErrMsg)
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(2, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".OpenSQLSafe")
End Function

Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
On Error GoTo ErrHandler

tryAgain:
    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        MsgBox ("Execution failed")
        
        If GetArrayValue(ao_Db.SQLErrorCodes, 0) = 547 Then
            Err.Raise 3, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        End If
        
        Dim ls_ErrMsg As String
        ls_ErrMsg = Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        
        If ReconnectSafe() Then
            GoTo tryAgain
        End If
        
        Err.Raise 1, "SQL : " & as_Request, ls_ErrMsg
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise 4, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise 5, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If
    
    Exit Sub

ErrHandler:
    Call ErrorHandler(Me.Name & ".ExecuteSQLSafe")
End Sub


Private Function GetArrayValue(ByRef ao_variantArray As Variant, ByVal al_Index As Long) As Variant
    If IsArray(ao_variantArray) Then
        If UBound(ao_variantArray) <= al_Index Then
            GetArrayValue = ao_variantArray(al_Index)
        Else
            GetArrayValue = 0
        End If
    Else
        GetArrayValue = 0
    End If
End Function

Private Function Get_A_Config(ByVal TheKey As String) As String
On Error GoTo Get_A_Config_er
Dim curs As Long
Dim ls_req As String

    Get_A_Config = ""
    ls_req = "select cfg_value from A_config where cfg_Key ='" & UCase(TheKey) & "'"
    curs = OpenSQLSafe(mo_Db, ls_req, 1)
    
    Get_A_Config = mo_Db.GetFields(curs, 0)
    Call mo_Db.Close(curs)
    curs = 0
    
Exit Function
Get_A_Config_er:
    If curs > 0 Then
        Call mo_Db.Close(curs)
        curs = 0
    End If
    Call ErrorHandler("Get_A_Config()")
End Function

Private Function SetComboItemValue(ByRef ao_cbo As ArmCombobox, ByVal as_Key As String) As Boolean
On Error GoTo ErrorHandler
    SetComboItemValue = True
    If Not ao_cbo.SearchItem(as_Key) Then
        Call ao_cbo.Load
        SetComboItemValue = ao_cbo.SearchItem(as_Key)
    End If
    Exit Function
ErrorHandler:
    Call ErrorHandler(Me.Name & ".SetComboItemValue")
End Function

Private Function Item_ReplacePlaceholders(ls_retVal As String) As String
On Error GoTo ErrHandler

    ls_retVal = Replace(ls_retVal, "$DC_CARRIER_Code$", SQLNum(GetCboValue(cbo_carrier, "DC_CARRIER_Code")), , , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$TRANS_Date$", SqlDate(StringToDate(txt_ShipDate.Text)), , , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$MASTER_TRANS_code$", SQLNum(GetCboKey(cbo_masterTran)), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$TRANS_Order$", SQLNum(txt_tranOrder.Text), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Supplier_Name$", SqlStr(txt_ShipFromDC.Text, 80), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$EQ_code$", SqlStr(cbo_Equipement.Text, 30, True), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$CUSTN1$", SqlStr(txt_CustName.Text, 80), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Ship_To_CT_Code$", SqlStr(GetCboKey(cbo_country), 4, True), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Ship_To_Zip_Code$", SqlStr(Trim(cbo_postCode.Text), 20, True), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Ship_To_Address$", SqlStr(txt_ShipAdd.Text, 80), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Order_Number$", SqlStr(txt_CLSOrderNb.Text, 20), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Shipment_Number$", SqlStr(txt_CLSShipNb.Text, 20), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Delivery_Number$", SqlStr(cbo_delivery.Text, 20), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Delivery_Date$", SqlDate(StringToDate(txt_DeliveryDate.Text)), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Quantity$", SQLNum(txt_QuantityWeight.Text), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Quantity_loaded$", SQLNum(txt_RealQuantity.Text), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Palletes$", SQLNum(txt_palletes.Text), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$UOM_code$", SqlStr(cbo_UOM.Text, 4, True), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Stand_Trailer$", SqlStr(IIf(Opt_Yes.Value, "Y", "N")), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$COS_Contact$", SqlStr(txt_COSContact.Text, 15), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Remark$", SqlStr(txt_RSRequire.Text, 240), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Haulier_Booking_Number$", SqlStr(txt_HaulierBookNb, 15), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Load_Planned_Starting_Time$", SqlStr(DateFormat(txt_LoadPlanStartTime.Text), 4), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Load_Planned_Ending_Time$", SqlStr(DateFormat(txt_LoadPlanEndTime.Text), 4), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Load_Arrival_Time$", SqlStr(DateFormat(txt_ArrivalTime.Text), 4), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Trailer_Number$", SqlStr(txt_TrailerNb, 15), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Load_Starting_Time$", SqlStr(DateFormat(txt_LoadStartTime.Text), 4), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Load_Ending_Time$", SqlStr(DateFormat(txt_LoadEndTime.Text), 4), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Load_By$", SqlStr(txt_LoadBy.Text, 15), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$CUST_Freight_Cost$", SQLNum(txt_paidByCustomer.Text), , , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$CUST_FC_Currency$", SqlStr(GetCboKey(cbo_currency), 5, True), , vbTextCompare)
    ls_retVal = Replace(ls_retVal, "$Receiving_DC$", SqlStr(IIf(chk_isReturn.Value = vbChecked, ms_DC_Code, ""), 4, True), , vbTextCompare)

    Item_ReplacePlaceholders = ls_retVal
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".Item_ReplacePlaceholders")
End Function

Private Function GetCboKey(ByRef ao_cbo As ArmCombobox) As String
On Error GoTo ErrHandler
    GetCboKey = ""
    If Not ao_cbo.SelectedItem Is Nothing Then
        GetCboKey = ao_cbo.SelectedItem.Key
    End If
    Exit Function
ErrHandler:
     Call ErrorHandler("GetCboKey()")
End Function

Private Function GetCboValue(ByRef ao_cbo As ArmCombobox, ByVal av_field As Variant, Optional ByVal as_DefaultValue As String = "") As String
On Error GoTo ErrHandler
    GetCboValue = as_DefaultValue
    If Not ao_cbo.SelectedItem Is Nothing Then
    
        Dim ls_retVal As String
        ls_retVal = ao_cbo.GetItemData(ao_cbo.SelectedItem.Key, av_field)
        
        If ls_retVal <> "" Then
            GetCboValue = ls_retVal
        End If
    
    End If
    Exit Function
ErrHandler:
     Call ErrorHandler("GetCboValue()")
End Function



Private Sub EnableControl(ByVal ao_Control As Control, ByVal ab_Enabled As Boolean)
On Error GoTo ErrHandler

    Select Case UCase(TypeName(ao_Control))
        Case "FRAME", "LABEL", "MSFLEXGRID", "SHAPE", "ARMGRID", "ARMCHECKVIEW", "TABSTRIP"
            ao_Control.Enabled = ab_Enabled
            ' Do nothing !
        Case "LISTVIEW"
            ' Do nothing !
        Case "TEXTBOX"
            ao_Control.Locked = Not ab_Enabled
            ao_Control.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
            ao_Control.TabStop = ab_Enabled
        Case "OPTIONBUTTON"
            ao_Control.Enabled = ab_Enabled
        Case "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "CHECKBOX", "COMBOBOX", "PICTUREBOX", "COMMANDBUTTON", "TOOLBARCONTROL"
            ao_Control.Enabled = ab_Enabled
            ao_Control.TabStop = ab_Enabled
        Case "DCCOST"
            ao_Control.Enabled = ab_Enabled
            ao_Control.TabStop = ab_Enabled
        Case Else
          Debug.Print ao_Control.Name
    End Select
  Exit Sub
ErrHandler:
  Call ErrorHandler("EnableControl")
End Sub

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call EnableControl(lo_ctrl, ab_Value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler(Me.Name & ".SetEnabled()")
End Sub

Private Function GetContainedControlsChain(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        If Not TypeOf lo_Control Is CommonDialog Then
                If ao_parent.hwnd = lo_Control.Container.hwnd Then
                    If TypeOf lo_Control Is Frame Then
                        Dim lo_aux_collection As New Collection
                        Dim ll_i As Long
                        Set lo_aux_collection = GetContainedControlsChain(lo_Control)
                        For ll_i = 1 To lo_aux_collection.Count
                            lo_retCollection.Add (lo_aux_collection.Item(ll_i))
                        Next
                    Else
                        Call lo_retCollection.Add(lo_Control)
                    End If
                End If
        End If
    Next
    Set GetContainedControlsChain = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetContainedControlsChain()")
End Function

' update transport cost for the transactions direct into database
' cbo_UOM must be selected !!!
' txt_QuantityWeight.Text must be valid numeric !!!!!
Private Sub UpdateTransportCost(ByVal al_currerntTransaction As Long)
On Error GoTo ErrHandler
    If Not SupportPriceList Then Exit Sub
    
    Debug.Assert (GetCboKey(cbo_UOM) <> "")
    Debug.Assert (CheckNumericValue(txt_QuantityWeight.Text))
    

    Dim lb_isFullTruck As Boolean
    Dim lb_isFullTruckCost As Boolean
    Dim lb_overLoaded As Boolean
    Dim lb_overLoadedCost As Boolean
    Dim lb_mixedUOM As Boolean
    Dim lb_isTrailer As Boolean
    
    Call CheckTransportCost(Val(GetCboValue(cbo_UOM, "DropOff_Cost", "0")), GetCboValue(cbo_UOM, "FullTruckCalculation", "Y"), lb_isFullTruck, lb_overLoaded, lb_overLoadedCost, lb_mixedUOM, lb_isFullTruckCost, lb_isTrailer)
    Debug.Assert (Not lb_overLoaded)
    Debug.Assert (Not lb_mixedUOM)
    
    Dim ll_CurrentLine As Long
    ll_CurrentLine = GetDCTransportLine(al_currerntTransaction)
    
    Dim ll_mostExpensiveLine As Long
    ll_mostExpensiveLine = GetMostExpensiveTransportLine()
    
Const C_REQ_DEL As String = "DELETE FROM DC_Cost WHERE TRANS_Code=$TRANS_Code$ AND DCC_type IN ('T', 'D')"
Const C_REQ_INS As String = "EXEC DC_Cost_ins $TRANS_Code$,$DCC_type$,$DCPLLI_Code$,$CURR_code$,$DC_Cost$,$DC_Comment$,$Z_Creator$"

    ' update the transport cost for each transaction
    Dim ld_qtyCost As Double
    ld_qtyCost = GetTotalQty(QTY_FOR_COST)
    
    Dim ll_i As Long
    For ll_i = LBound(moa_DCTransport_cost) To UBound(moa_DCTransport_cost)
    
        If ll_i <> ll_CurrentLine Then
            Debug.Assert (al_currerntTransaction <> moa_DCTransport_cost(ll_i).TRANS_Code)
        
            Dim ll_TRANS_Code As Long
            ll_TRANS_Code = moa_DCTransport_cost(ll_i).TRANS_Code
            
            'DELETE EXISTING PRICES
            Call ExecuteSQLSafe(mo_Db, Replace(C_REQ_DEL, "$TRANS_Code$", SQLNum(ll_TRANS_Code), , , vbTextCompare))
            
            Dim ls_req As String
        
            ' get the data and update them
            ls_req = Replace(C_REQ_INS, "$TRANS_Code$", SQLNum(ll_TRANS_Code), , , vbTextCompare)
            
            If lb_isFullTruckCost Then
                ' if we are not in master transaction then generate dropoff cost
                If ll_mostExpensiveLine = ll_i Then
                    If moa_DCTransport_cost(ll_i).DCPLLI_code <> 0 Then
                        ' insert full truck transport cost for most expensive transport
                        
                        ls_req = Replace(ls_req, "$DCC_type$", SqlStr("T", 1), , , vbTextCompare)
                        
                        If lb_isTrailer Then
                            ' have to go into database for specific trailer cost
                            Call UpdatePriceTrailer_tran(moa_DCTransport_cost(ll_i), ld_qtyCost)
                        End If
                            
                        ls_req = Replace(ls_req, "$DCPLLI_Code$", SQLNum(moa_DCTransport_cost(ll_i).DCPLLI_code), , , vbTextCompare)
                        ls_req = Replace(ls_req, "$DC_Cost$", SQLNum(GetPriceFullTruck(moa_DCTransport_cost(ll_i), ld_qtyCost)), , , vbTextCompare)
                    Else
                        'cancel creation of a cost
                        ls_req = ""
                    End If
                Else
                    ' generate dropoff cost
                    ls_req = Replace(ls_req, "$DCC_type$", SqlStr("D", 1), , , vbTextCompare)
                    ls_req = Replace(ls_req, "$DCPLLI_Code$", SQLNum(moa_DCTransport_cost(ll_i).DCPLLI_code), , , vbTextCompare)
                    ls_req = Replace(ls_req, "$DC_Cost$", SQLNum(GetCboValue(cbo_UOM, "DropOff_Cost")), , , vbTextCompare)
                End If
            Else
                If moa_DCTransport_cost(ll_i).DCPLLI_code <> 0 Then
                    ' generate the transport cost
                    ls_req = Replace(ls_req, "$DCC_type$", SqlStr("T", 1), , , vbTextCompare)
                    ls_req = Replace(ls_req, "$DCPLLI_Code$", SQLNum(moa_DCTransport_cost(ll_i).DCPLLI_code), , , vbTextCompare)
                    ls_req = Replace(ls_req, "$DC_Cost$", SQLNum(GetPrice(moa_DCTransport_cost(ll_i))), , , vbTextCompare)
                Else
                    'cancel creation of a cost
                    ls_req = ""
                End If
            End If
            
            If ls_req <> "" Then
            
                ls_req = Replace(ls_req, "$DC_Comment$", SqlStr(""), , , vbTextCompare)
                ls_req = Replace(ls_req, "$CURR_code$", SqlStr(moa_DCTransport_cost(ll_i).DCPLLI_CURR_Code), , , vbTextCompare)
                ls_req = Replace(ls_req, "$Z_Creator$", SqlStr(ms_LoginName, 15), , , vbTextCompare)
                
                Call ExecuteSQLSafe(mo_Db, ls_req)
            
            End If
        End If
        
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Me.Name & ".UpdateTransportCost()")
End Sub


Private Sub UpdateTransportCost_all(ByVal ad_dropOffCost As Double, ByVal as_FullTruckCalculation As String)
On Error GoTo ErrHandler
    
    Dim lb_isFullTruck As Boolean
    Dim lb_isFullTruckCost As Boolean
    Dim lb_overLoaded As Boolean
    Dim lb_overLoadedCost As Boolean
    Dim lb_mixedUOM As Boolean
    Dim lb_isTrailer As Boolean
    
    Call CheckTransportCost(ad_dropOffCost, as_FullTruckCalculation, lb_isFullTruck, lb_overLoaded, lb_overLoadedCost, lb_mixedUOM, lb_isFullTruckCost, lb_isTrailer)
    
    Debug.Assert (Not lb_overLoaded)
    Debug.Assert (Not lb_mixedUOM)
    
    Dim ll_mostExpensiveLine As Long
    ll_mostExpensiveLine = GetMostExpensiveTransportLine()
    
Const C_REQ_DEL As String = "DELETE FROM DC_Cost WHERE TRANS_Code=$TRANS_Code$ AND DCC_type IN ('T', 'D')"
Const C_REQ_INS As String = "EXEC DC_Cost_ins $TRANS_Code$,$DCC_type$,$DCPLLI_Code$,$CURR_code$,$DC_Cost$,$DC_Comment$, $Z_Creator$"

    ' update the transport cost for each transaction
    Dim ld_qtyCost As Double
    ld_qtyCost = GetTotalQty(QTY_FOR_COST)
    
    Dim ll_i As Long
    For ll_i = LBound(moa_DCTransport_cost) To UBound(moa_DCTransport_cost)
    
        Dim ll_TRANS_Code As Long
        ll_TRANS_Code = moa_DCTransport_cost(ll_i).TRANS_Code
        
        'DELETE EXISTING PRICES
        Call ExecuteSQLSafe(mo_Db, Replace(C_REQ_DEL, "$TRANS_Code$", SQLNum(ll_TRANS_Code), , , vbTextCompare))
        
        Dim ls_req As String
    
        ' get the data and update them
        ls_req = Replace(C_REQ_INS, "$TRANS_Code$", SQLNum(ll_TRANS_Code), , , vbTextCompare)
        
        If lb_isFullTruckCost Then
            ' if we are not in master transaction then generate dropoff cost
            If ll_mostExpensiveLine = ll_i Then
                If moa_DCTransport_cost(ll_i).DCPLLI_code <> 0 Then
                    ' insert full truck transport cost for most expensive transport
                    
                    ls_req = Replace(ls_req, "$DCC_type$", SqlStr("T", 1), , , vbTextCompare)
                    
                    If lb_isTrailer Then
                        ' have to go into database for specific trailer cost
                        Call UpdatePriceTrailer_tran(moa_DCTransport_cost(ll_i), ld_qtyCost)
                    End If
                        
                    ls_req = Replace(ls_req, "$DCPLLI_Code$", SQLNum(moa_DCTransport_cost(ll_i).DCPLLI_code), , , vbTextCompare)
                    ls_req = Replace(ls_req, "$DC_Cost$", SQLNum(GetPriceFullTruck(moa_DCTransport_cost(ll_i), ld_qtyCost)), , , vbTextCompare)
                Else
                    ' cancel creation of transport cost
                    ls_req = ""
                End If
            Else
                ' generate dropoff cost
                ls_req = Replace(ls_req, "$DCC_type$", SqlStr("D", 1), , , vbTextCompare)
                ls_req = Replace(ls_req, "$DCPLLI_Code$", SQLNum(moa_DCTransport_cost(ll_i).DCPLLI_code), , , vbTextCompare)
                ls_req = Replace(ls_req, "$DC_Cost$", SQLNum(ad_dropOffCost), , , vbTextCompare)
            End If
        Else
            If moa_DCTransport_cost(ll_i).DCPLLI_code <> 0 Then
    
                ' generate the transport cost
                ls_req = Replace(ls_req, "$DCC_type$", SqlStr("T", 1), , , vbTextCompare)
                ls_req = Replace(ls_req, "$DCPLLI_Code$", SQLNum(moa_DCTransport_cost(ll_i).DCPLLI_code), , , vbTextCompare)
                ls_req = Replace(ls_req, "$DC_Cost$", SQLNum(GetPrice(moa_DCTransport_cost(ll_i))), , , vbTextCompare)
            Else
                ' cancel creation of transport cost
                ls_req = ""
            End If
        End If
        
        If ls_req <> "" Then
        
            ls_req = Replace(ls_req, "$DC_Comment$", SqlStr(""), , , vbTextCompare)
            ls_req = Replace(ls_req, "$CURR_code$", SqlStr(moa_DCTransport_cost(ll_i).DCPLLI_CURR_Code), , , vbTextCompare)
            ls_req = Replace(ls_req, "$Z_Creator$", SqlStr(ms_LoginName, 15), , , vbTextCompare)
            
            Call ExecuteSQLSafe(mo_Db, ls_req)
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Me.Name & ".UpdateTransportCost_all()")
End Sub

' generate surcharge cost for currently edited record
Private Function GenerateSurchargeCost() As Boolean
On Error GoTo ErrHandler
    GenerateSurchargeCost = False
    
    ' clean generated cost info
    Call DCCost1.DeleteCostLine("S")
    
    Dim ll_CurrentLine As Long
    ll_CurrentLine = GetDCTransportLine(ml_d)
    
    If Not SupportPriceList _
        Or GetCboKey(cbo_UOM) = "" _
        Or GetCboKey(cbo_country) = "" _
        Or Trim(cbo_postCode.Text) = "" _
        Or ckv_surcharges.CheckedCount = 0 Then
        
        Debug.Assert (moa_DCTransport_cost(ll_CurrentLine).DCPL_Code = Val(GetCboValue(cbo_UOM, "DCPL_Code")))

        ' set prices at zero
        ReDim moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(0) As tDCSurcharge_cost
        
        moa_DCTransport_cost(ll_CurrentLine).Surcharge_Cost = 0
        moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(0).DCS_Code = ""
        moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(0).DCS_Price = 0
        moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(0).DCS_quantity = 1
        moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(0).SurchargeFormula = "Price"
    Else
        
        ' 1. update current line with surcharge price and formula
        Dim ld_surchargeCost As Double
        ld_surchargeCost = 0
        
        Dim ll_i As Long
        
        Dim ll_checked_ind  As Long
        ll_checked_ind = 0
        
        Dim ll_surchRows As Long
        ll_surchRows = ckv_surcharges.CheckedCount
        If ll_surchRows > 0 Then
            ReDim moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_surchRows - 1) As tDCSurcharge_cost
        
            For ll_i = 1 To ckv_surcharges.Count
                If ckv_surcharges.ListItems(ll_i).Checked Then
                    moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).DCS_Code = ckv_surcharges.ListItems(ll_i).Tag.Id
                    moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).SurchargeFormula = ckv_surcharges.ListItems(ll_i).Tag.GetData(SURCHARGE_COLS.DCS_Formula)
                    moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).DCS_Price = ckv_surcharges.ListItems(ll_i).Tag.GetData(SURCHARGE_COLS.DCS_Price)
                    moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).DCS_quantity = ckv_surcharges.ListItems(ll_i).Tag.GetData(SURCHARGE_COLS.DCS_quantity)
                    
                    ' generate the surcharge cost
                    ld_surchargeCost = ld_surchargeCost + GetSurchargePrice(moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind), DCCost1.TransportCost)
                
                    ll_checked_ind = ll_checked_ind + 1
                End If
            Next
        Else
            ReDim moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(0) As tDCSurcharge_cost
            moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).DCS_Code = ""
            moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).SurchargeFormula = "Price"
            moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).DCS_Price = 0
            moa_DCTransport_cost(ll_CurrentLine).SurchargeInfo(ll_checked_ind).DCS_quantity = 1
        End If
        
        moa_DCTransport_cost(ll_CurrentLine).Surcharge_Cost = ld_surchargeCost
        
        Call DCCost1.UpdateCostLine("S", 0, moa_DCTransport_cost(ll_CurrentLine).Surcharge_Cost, moa_DCTransport_cost(ll_CurrentLine).DCPLLI_CURR_Code)
    End If
    
    GenerateSurchargeCost = True

    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GenerateSurchargeCost()")
End Function

' generate transport cost for currently edited record
Private Function GenerateTransportCost() As Boolean
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC DC_PriceListPrice_sel $DCPL_Code$, $Ship_To_CT_Code$, $Ship_To_Zip_Code$, $Quantity_for_cost$, $IsReturn$"
    
    GenerateTransportCost = True
    
    Dim ll_CurrentLine As Long
    Dim lb_isFullTruck As Boolean
    Dim lb_isFullTruckCost As Boolean
    Dim lb_overLoaded As Boolean
    Dim lb_overLoadedCost As Boolean
    Dim lb_mixedUOM As Boolean
    Dim lb_isTrailer As Boolean
    
    ll_CurrentLine = GetDCTransportLine(ml_d)
    
    If Not SupportPriceList _
        Or GetCboKey(cbo_UOM) = "" _
        Or GetCboKey(cbo_country) = "" _
        Or Trim(cbo_postCode.Text) = "" _
        Or (txt_QuantityWeight.Text = "" Or Not CheckNumericValue(txt_QuantityWeight.Text)) Then
        
        ' clean generated cost info
        Call DCCost1.DeleteCostLine("D")
        Call DCCost1.DeleteCostLine("T")

        moa_DCTransport_cost(ll_CurrentLine).DCPL_Code = Val(GetCboValue(cbo_UOM, "DCPL_Code"))

        ' set prices at zero
        moa_DCTransport_cost(ll_CurrentLine).DCPLLI_code = 0
        moa_DCTransport_cost(ll_CurrentLine).DCPLLI_Price = 0
        moa_DCTransport_cost(ll_CurrentLine).DCPLLI_CURR_Code = "EUR"       ' todo:
        moa_DCTransport_cost(ll_CurrentLine).UOM_Code = GetCboKey(cbo_UOM)
        moa_DCTransport_cost(ll_CurrentLine).IsReturn = (chk_isReturn.Value = vbChecked)
                
        moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Price = 0
        moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Min = GetCurrentQty(QTY_FOR_TRANSPORT)
        moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Max = GetCurrentQty(QTY_FOR_COST)
        moa_DCTransport_cost(ll_CurrentLine).DCPLL_Trailer_min = 0
        
        moa_DCTransport_cost(ll_CurrentLine).PriceFormula = "Price"
        moa_DCTransport_cost(ll_CurrentLine).FullTruckPriceFormula = "Price"
    
        If Not mb_PL_STYLE_ENABLED Then
            'for old style settings we are done
            txt_totalCost.Text = Format(GetTotalCost(False, 0, md_manualCost, True), "###0.00")
            Call PropagateTotalQty(GetTotalQty(QTY_FOR_TRANSPORT), 0, GetTotalQty(QTY_FOR_COST), CDbl(txt_totalCost.Text))
            Exit Function
        End If
        
        GenerateTransportCost = False
    
        lb_isFullTruck = False
        lb_isFullTruckCost = False
        lb_overLoaded = False
        lb_overLoadedCost = False
        lb_mixedUOM = False
        lb_isTrailer = False
    Else
        
        GenerateTransportCost = False
        
        ' 1. update current line with full truck and the prices
        Dim ll_Cursor As Long
        
        Dim ls_req As String
        ls_req = Replace(C_REQ, "$DCPL_Code$", SQLNum(GetCboValue(cbo_UOM, "DCPL_Code")), , , vbTextCompare)
        ls_req = Replace(ls_req, "$Quantity_for_cost$", SQLNum(GetCurrentQty(QTY_FOR_COST)), , vbTextCompare)
        ls_req = Replace(ls_req, "$IsReturn$", SqlStr(IIf(chk_isReturn.Value = vbChecked, "X", ""), 1), , vbTextCompare)
        
        
        Call Item_ReplacePlaceholders(ls_req)
        
        ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
        If mo_Db.RowCount(ll_Cursor) > 0 Then
            
            moa_DCTransport_cost(ll_CurrentLine).DCPLLI_code = mo_Db.GetFields(ll_Cursor, "DCPLLI_Code")
            moa_DCTransport_cost(ll_CurrentLine).DCPLLI_Price = mo_Db.GetFields(ll_Cursor, "DCPLLI_Price")
            moa_DCTransport_cost(ll_CurrentLine).DCPLLI_CURR_Code = mo_Db.GetFields(ll_Cursor, "DCPLLI_CURR_Code")
        
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Price = mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_Price")
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Min = mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_min")
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Max = mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_max")
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Trailer_min = mo_Db.GetFields(ll_Cursor, "DCPLL_Trailer_min")
            
            moa_DCTransport_cost(ll_CurrentLine).PriceFormula = mo_Db.GetFields(ll_Cursor, "PriceFormula")
            moa_DCTransport_cost(ll_CurrentLine).FullTruckPriceFormula = mo_Db.GetFields(ll_Cursor, "FullTruckPriceFormula")
            moa_DCTransport_cost(ll_CurrentLine).IsReturn = (mo_Db.GetFields(ll_Cursor, "IsReturn") = "X")
        
        Else
            
            moa_DCTransport_cost(ll_CurrentLine).DCPLLI_code = 0
            moa_DCTransport_cost(ll_CurrentLine).DCPLLI_Price = 0
            moa_DCTransport_cost(ll_CurrentLine).DCPLLI_CURR_Code = GetCboValue(cbo_UOM, "CURR_code", GetCboKey(cbo_currency))
        
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Price = 0
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Min = GetCurrentQty(QTY_FOR_TRANSPORT)
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Full_Truck_Max = GetCurrentQty(QTY_FOR_COST)
            moa_DCTransport_cost(ll_CurrentLine).DCPLL_Trailer_min = 0
            
            moa_DCTransport_cost(ll_CurrentLine).PriceFormula = "Price"
            moa_DCTransport_cost(ll_CurrentLine).FullTruckPriceFormula = "Price"
            moa_DCTransport_cost(ll_CurrentLine).IsReturn = (chk_isReturn.Value = vbChecked)
        
            If chk_manualPrice.Value = vbUnchecked And chk_isReturn.Value = vbUnchecked And GetCurrentQty(QTY_FOR_COST) > 0 Then
            
                ReDim ms_MsgInfo(0, 1)
                ms_MsgInfo(0, 0) = "$QTY_FOR_COST$"
                ms_MsgInfo(0, 1) = GetCurrentQty(QTY_FOR_COST)
                
                Call MsgBox(MsgText(5110, ms_Language_Code, "#Qty not supported by price list!!! ($QTY_FOR_COST$)", ms_MsgInfo), vbOKOnly)
            End If
            
        End If
        
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        
        Call CheckTransportCost(Val(GetCboValue(cbo_UOM, "DropOff_Cost", "0")), GetCboValue(cbo_UOM, "FullTruckCalculation", "Y"), lb_isFullTruck, lb_overLoaded, lb_overLoadedCost, lb_mixedUOM, lb_isFullTruckCost, lb_isTrailer)
    End If
    
    
    Dim ld_Qty As Double
    ld_Qty = GetTotalQty(QTY_FOR_TRANSPORT)
    
    Dim ld_qtyCost As Double
    ld_qtyCost = GetTotalQty(QTY_FOR_COST)
    
    
    If lb_mixedUOM Then
        Call MsgBox(MsgText(5070, ms_Language_Code, "#Mixed UOM!"), vbCritical Or vbOKOnly)
        Exit Function
    End If
    
    If lb_overLoaded Then
        ReDim ms_MsgInfo(1, 1)
        ms_MsgInfo(0, 0) = "$QTY_FOR_TRANSPORT$"
        ms_MsgInfo(0, 1) = ld_Qty
        ms_MsgInfo(1, 0) = "$UOM$"
        ms_MsgInfo(1, 1) = GetCboKey(cbo_UOM)
        Call MsgBox(MsgText(5120, ms_Language_Code, "#Truck is overloaded!!! ($QTY_FOR_TRANSPORT$ $UOM$)", ms_MsgInfo), vbCritical Or vbOKOnly)
        Exit Function
    End If

    If lb_overLoadedCost Then
        ' warning
        ReDim ms_MsgInfo(1, 1)
        ms_MsgInfo(0, 0) = "$QTY_FOR_COST$"
        ms_MsgInfo(0, 1) = ld_qtyCost
        ms_MsgInfo(1, 0) = "$UOM$"
        ms_MsgInfo(1, 1) = GetCboKey(cbo_UOM)
        Call MsgBox(MsgText(5080, ms_Language_Code, "#Ordered qty is overloading the truck! ($QTY_FOR_COST$ $UOM$)", ms_MsgInfo), vbInformation Or vbOKOnly)
    End If
    
    If lb_isFullTruckCost Then
        ' if we current price for full truck is most expensive then make the currect as main transport cost otherwise make it drop off cost
        
        Dim ll_mostExpensiveLine As Long
        ll_mostExpensiveLine = GetMostExpensiveTransportLine()
        
        If lb_isTrailer Then
            ' have to go into database for specific trailer cost
            Call UpdatePriceTrailer(moa_DCTransport_cost(ll_mostExpensiveLine), ld_qtyCost, GetCboKey(cbo_country), cbo_postCode.Text)
        End If
        
        If ll_mostExpensiveLine = ll_CurrentLine Then
            ' generate full truck cost
            Call DCCost1.DeleteCostLine("D")
            Call DCCost1.UpdateCostLine("T", moa_DCTransport_cost(ll_CurrentLine).DCPLLI_code, _
                                             GetPriceFullTruck(moa_DCTransport_cost(ll_CurrentLine), ld_qtyCost), _
                                             moa_DCTransport_cost(ll_CurrentLine).DCPLLI_CURR_Code)
        Else
            ' generate dropoff cost
            Call DCCost1.DeleteCostLine("T")
            Call DCCost1.UpdateCostLine("D", moa_DCTransport_cost(ll_CurrentLine).DCPLLI_code, GetCboValue(cbo_UOM, "DropOff_Cost"), moa_DCTransport_cost(ll_CurrentLine).DCPLLI_CURR_Code)
            
        End If
    Else
        ' generate the transport cost
        Call DCCost1.DeleteCostLine("D")
        Call DCCost1.UpdateCostLine("T", moa_DCTransport_cost(ll_CurrentLine).DCPLLI_code, GetPrice(moa_DCTransport_cost(ll_CurrentLine)), moa_DCTransport_cost(ll_CurrentLine).DCPLLI_CURR_Code)
    End If
    
    GenerateTransportCost = True

    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Me.Name & ".GenerateTransportCost()")
End Function

Private Sub UpdateTotalCost()
On Error GoTo ErrHandler

    Dim lb_isFullTruck As Boolean
    Dim lb_isFullTruckCost As Boolean
    Dim lb_overLoaded As Boolean
    Dim lb_overLoadedCost As Boolean
    Dim lb_mixedUOM As Boolean
    Dim lb_isTrailer As Boolean

    Call CheckTransportCost(Val(GetCboValue(cbo_UOM, "DropOff_Cost", "0")), GetCboValue(cbo_UOM, "FullTruckCalculation", "Y"), lb_isFullTruck, lb_overLoaded, lb_overLoadedCost, lb_mixedUOM, lb_isFullTruckCost, lb_isTrailer)

    Dim ll_CurrentLine As Long
    ll_CurrentLine = GetDCTransportLine(ml_d)
    
    txt_totalCost.Text = Format(GetTotalCost(lb_isFullTruckCost, Val(GetCboValue(cbo_UOM, "DropOff_Cost")), md_manualCost, True), "###0.00")

    Dim ld_Qty As Double
    ld_Qty = GetTotalQty(QTY_FOR_TRANSPORT)
    
    Dim ld_qtyCost As Double
    ld_qtyCost = GetTotalQty(QTY_FOR_COST)
    
    Call PropagateTotalQty(ld_Qty, IIf(lb_isTrailer, moa_DCTransport_cost(ll_CurrentLine).DCPLL_Trailer_min, 0), ld_qtyCost, GetTotalCost(lb_isFullTruckCost, Val(GetCboValue(cbo_UOM, "DropOff_Cost")), md_manualCost, False))

    Exit Sub
ErrHandler:
    Call ErrorHandler(Me.Name & ".UpdateTotalCost()")
End Sub

Private Function GetTotalCost(ByVal ab_fullTruck As Boolean, ByVal ad_dropOffCost As Double, ByRef ad_manualCost As Double, ByVal ab_allSurcharges As Boolean) As Double
On Error GoTo ErrHandler
    Dim ll_i As Long
    Dim ld_totalCost As Double
    
    ad_manualCost = 0
    
    Dim ll_mostExpensiveLine As Long
    ll_mostExpensiveLine = GetMostExpensiveTransportLine()
    
    For ll_i = LBound(moa_DCTransport_cost) To UBound(moa_DCTransport_cost)
        If ab_fullTruck Then
            If ll_i = ll_mostExpensiveLine Then
                ld_totalCost = ld_totalCost + GetPriceFullTruck(moa_DCTransport_cost(ll_i), GetTotalQty(QTY_FOR_COST))
            Else
                ld_totalCost = ld_totalCost + ad_dropOffCost
            End If
        Else
            ld_totalCost = ld_totalCost + GetPrice(moa_DCTransport_cost(ll_i))
        End If
        ld_totalCost = ld_totalCost + moa_DCTransport_cost(ll_i).Manual_Cost
        If ab_allSurcharges Then
            
            ld_totalCost = ld_totalCost + moa_DCTransport_cost(ll_i).Surcharge_Cost
        
        End If
        ad_manualCost = ad_manualCost + moa_DCTransport_cost(ll_i).Manual_Cost
    Next
    
    GetTotalCost = ld_totalCost
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetTotalCost()")
End Function

Private Function UniqueTransactions(ByVal al_Cursor As Long) As Long
On Error GoTo ErrHandler
    
    Call mo_Db.First(al_Cursor)
    
    Dim ll_oldTran As Long
    ll_oldTran = 0
    
    Dim ll_tranCount As Long
    ll_tranCount = 0
    
    While Not mo_Db.EOF(al_Cursor)
        If ll_oldTran <> mo_Db.GetFields(al_Cursor, "TRANS_Code") Then
            ll_oldTran = mo_Db.GetFields(al_Cursor, "TRANS_Code")
            ll_tranCount = ll_tranCount + 1
        End If
        Call mo_Db.Next(al_Cursor)
    Wend

    UniqueTransactions = ll_tranCount
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".UniqueTransactions()")
End Function

Private Function UniqueSurcharges(ByVal al_Cursor As Long) As Long
On Error GoTo ErrHandler

    Dim ll_TRANS_Code As Long
    ll_TRANS_Code = mo_Db.GetFields(al_Cursor, "TRANS_code")
    
    Dim ll_surchCount As Long
    ll_surchCount = 0
    
    Dim ll_oldPos As Long
    ll_oldPos = mo_Db.Position(al_Cursor)
    
    While Not mo_Db.EOF(al_Cursor)
        If ll_TRANS_Code = mo_Db.GetFields(al_Cursor, "TRANS_Code") Then
            ll_surchCount = ll_surchCount + 1
        End If
        Call mo_Db.Next(al_Cursor)
    Wend
    
    mo_Db.Position(al_Cursor) = ll_oldPos
    
    UniqueSurcharges = ll_surchCount
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".UniqueSurcharges()")
End Function


Private Sub InitTransportCost(ByVal al_currentTrans_Code As Long, ByVal al_masterTran As Long, ByVal al_DCPL_Code As Long)
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC DC_PriceListPrice_lst $DCPL_Code$, $MASTER_TRANS_code$, $IsReturn$"
    
    Dim ll_Cursor As Long
    Dim ll_Rows As Long
    ll_Rows = 0
    
    Dim ll_surchRows As Long
    Dim ll_i As Long
    Dim ll_i_surch As Long
    
    If al_masterTran <> 0 Then
        
        Dim ls_req As String
    
        ls_req = Replace(C_REQ, "$DCPL_Code$", SQLNum(al_DCPL_Code), , , vbTextCompare)
        ls_req = Replace(ls_req, "$MASTER_TRANS_code$", SQLNum(al_masterTran), , vbTextCompare)
        ls_req = Replace(ls_req, "$IsReturn$", SqlStr("", 1, True), , vbTextCompare)
    
        ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
        ll_Rows = UniqueTransactions(ll_Cursor)
        
        If ll_Rows > 0 Then

            ' check if ml_d exists in cursor
            If mo_Db.FindBinary(ll_Cursor, "TRANS_Code", al_currentTrans_Code) < 0 And al_currentTrans_Code <> -1 Then
                ReDim moa_DCTransport_cost(ll_Rows) As tDCTransport_cost
                ll_Rows = 0
            Else
                ReDim moa_DCTransport_cost(ll_Rows - 1) As tDCTransport_cost
            End If
        
            ll_i = LBound(moa_DCTransport_cost)
            Call mo_Db.First(ll_Cursor)
            
            Dim ll_oldTran As Long
            ll_oldTran = 0
        
            While Not mo_Db.EOF(ll_Cursor)
                
                If ll_oldTran <> mo_Db.GetFields(ll_Cursor, "TRANS_Code") Then
                    ll_oldTran = mo_Db.GetFields(ll_Cursor, "TRANS_Code")
                    
                    moa_DCTransport_cost(ll_i).DCPL_Code = al_DCPL_Code
                    moa_DCTransport_cost(ll_i).TRANS_Code = mo_Db.GetFields(ll_Cursor, "TRANS_code")
                    moa_DCTransport_cost(ll_i).UOM_Code = mo_Db.GetFields(ll_Cursor, "UOM_code")
                    moa_DCTransport_cost(ll_i).Quantity = mo_Db.GetFields(ll_Cursor, "Quantity")
                    moa_DCTransport_cost(ll_i).Quantity_loaded = mo_Db.GetFields(ll_Cursor, "Quantity_loaded")
                    moa_DCTransport_cost(ll_i).IsReturn = (mo_Db.GetFields(ll_Cursor, "IsReturn") = "X")

                    moa_DCTransport_cost(ll_i).DCPLLI_code = mo_Db.GetFields(ll_Cursor, "DCPLLI_Code")
                    moa_DCTransport_cost(ll_i).DCPLLI_Price = mo_Db.GetFields(ll_Cursor, "DCPLLI_Price")
                    moa_DCTransport_cost(ll_i).DCPLLI_CURR_Code = mo_Db.GetFields(ll_Cursor, "DCPLLI_CURR_Code")
                    moa_DCTransport_cost(ll_i).Manual_Cost = mo_Db.GetFields(ll_Cursor, "Manual_Cost")
                    moa_DCTransport_cost(ll_i).Surcharge_Cost = mo_Db.GetFields(ll_Cursor, "Surcharge_Cost")
            
                    moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Price = mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_Price")
                    
                    If mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_min") <> 0 Then
                        moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Min = mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_min")
                    Else
                        moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Min = GetTranQty(ll_i, QTY_FOR_TRANSPORT)
                    End If
                    
                    If mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_max") <> 0 Then
                        moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Max = mo_Db.GetFields(ll_Cursor, "DCPLL_Full_Truck_max")
                    Else
                        moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Max = GetTranQty(ll_i, QTY_FOR_COST)
                    End If
                    moa_DCTransport_cost(ll_i).DCPLL_Trailer_min = mo_Db.GetFields(ll_Cursor, "DCPLL_Trailer_min")
                
                    moa_DCTransport_cost(ll_i).PriceFormula = mo_Db.GetFields(ll_Cursor, "PriceFormula")
                    moa_DCTransport_cost(ll_i).FullTruckPriceFormula = mo_Db.GetFields(ll_Cursor, "FullTruckPriceFormula")
                
                    ' dimension for surcharge info
                    ll_surchRows = UniqueSurcharges(ll_Cursor)
                    ReDim moa_DCTransport_cost(ll_i).SurchargeInfo(ll_surchRows - 1) As tDCSurcharge_cost
                    ll_i_surch = LBound(moa_DCTransport_cost(ll_i).SurchargeInfo)
                    
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_i_surch).DCS_Code = mo_Db.GetFields(ll_Cursor, "DCS_Code")
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_i_surch).SurchargeFormula = mo_Db.GetFields(ll_Cursor, "SurchargeFormula")
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_i_surch).DCS_Price = mo_Db.GetFields(ll_Cursor, "DCS_Price")
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_i_surch).DCS_quantity = mo_Db.GetFields(ll_Cursor, "DCS_quantity")

                    ' current data are loaded from UI
                    If moa_DCTransport_cost(ll_i).TRANS_Code = al_currentTrans_Code Then
                        moa_DCTransport_cost(ll_i).Quantity = Val(txt_QuantityWeight.Text)
                        moa_DCTransport_cost(ll_i).Quantity_loaded = Val(txt_RealQuantity.Text)
                        moa_DCTransport_cost(ll_i).SurchargeInfo(ll_i_surch).DCS_quantity = 1
                        
                        Debug.Assert (moa_DCTransport_cost(ll_i).UOM_Code = GetCboKey(cbo_UOM))
                        moa_DCTransport_cost(ll_i).IsReturn = (chk_isReturn.Value = vbChecked)
                    End If
                    
                    ll_i_surch = ll_i_surch + 1
                    ll_i = ll_i + 1
                Else
                    ' only load next surcharge
                    moa_DCTransport_cost(ll_i - 1).SurchargeInfo(ll_i_surch).DCS_Code = mo_Db.GetFields(ll_Cursor, "DCS_Code")
                    moa_DCTransport_cost(ll_i - 1).SurchargeInfo(ll_i_surch).SurchargeFormula = mo_Db.GetFields(ll_Cursor, "SurchargeFormula")
                    moa_DCTransport_cost(ll_i - 1).SurchargeInfo(ll_i_surch).DCS_Price = mo_Db.GetFields(ll_Cursor, "DCS_Price")
                    moa_DCTransport_cost(ll_i - 1).SurchargeInfo(ll_i_surch).DCS_quantity = mo_Db.GetFields(ll_Cursor, "DCS_quantity")
                    ll_i_surch = ll_i_surch + 1
                End If
                    
                    
                Call mo_Db.Next(ll_Cursor)
                
            Wend
        Else
            ReDim moa_DCTransport_cost(0) As tDCTransport_cost
            ReDim moa_DCTransport_cost(0).SurchargeInfo(0) As tDCSurcharge_cost
        End If

        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    Else
        ' we are in Add screen => initialize moa_DCTransport_cost
        ReDim moa_DCTransport_cost(0) As tDCTransport_cost
        ReDim moa_DCTransport_cost(0).SurchargeInfo(0) As tDCSurcharge_cost
    End If
    
    If ll_Rows = 0 Then
        ll_i = UBound(moa_DCTransport_cost)
    
        moa_DCTransport_cost(ll_i).DCPL_Code = Val(GetCboValue(cbo_UOM, "DCPL_Code"))
        
        moa_DCTransport_cost(ll_i).TRANS_Code = al_currentTrans_Code
        moa_DCTransport_cost(ll_i).Quantity = Val(txt_QuantityWeight.Text)
        moa_DCTransport_cost(ll_i).Quantity_loaded = Val(txt_RealQuantity.Text)
        moa_DCTransport_cost(ll_i).UOM_Code = GetCboKey(cbo_UOM)
        moa_DCTransport_cost(ll_i).IsReturn = (chk_isReturn.Value = vbChecked)
        
        moa_DCTransport_cost(ll_i).DCPLLI_code = 0
        moa_DCTransport_cost(ll_i).DCPLLI_Price = 0
        moa_DCTransport_cost(ll_i).DCPLLI_CURR_Code = GetCboValue(cbo_UOM, "CURR_code", GetCboKey(cbo_currency))
        moa_DCTransport_cost(ll_i).Manual_Cost = DCCost1.ManualCost
        moa_DCTransport_cost(ll_i).Surcharge_Cost = DCCost1.SurchargeCost
    
        moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Price = 0
        moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Min = 0
        moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Max = 0
        moa_DCTransport_cost(ll_i).DCPLL_Trailer_min = 0
        
        moa_DCTransport_cost(ll_i).PriceFormula = "Price"
        moa_DCTransport_cost(ll_i).FullTruckPriceFormula = "Price"
    
        ' init surcharges from UI
        ll_surchRows = ckv_surcharges.CheckedCount
        If ll_surchRows > 0 Then
            ReDim moa_DCTransport_cost(ll_i).SurchargeInfo(ll_surchRows - 1) As tDCSurcharge_cost
        
            Dim ll_checked_ind  As Long
            ll_checked_ind = 0
        
            For ll_i_surch = 1 To ckv_surcharges.Count
                If ckv_surcharges.ListItems(ll_i_surch).Checked Then
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).DCS_Code = ckv_surcharges.ListItems(ll_i_surch).Tag.Id
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).SurchargeFormula = ckv_surcharges.ListItems(ll_i_surch).Tag.GetData(SURCHARGE_COLS.DCS_Formula)
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).DCS_Price = ckv_surcharges.ListItems(ll_i_surch).Tag.GetData(SURCHARGE_COLS.DCS_Price)
                    moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).DCS_quantity = ckv_surcharges.ListItems(ll_i_surch).Tag.GetData(SURCHARGE_COLS.DCS_quantity)
                    ll_checked_ind = ll_checked_ind + 1
                End If
            Next
        Else
            ReDim moa_DCTransport_cost(ll_i).SurchargeInfo(0) As tDCSurcharge_cost
            moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).DCS_Code = ""
            moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).SurchargeFormula = "Price"
            moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).DCS_Price = 0
            moa_DCTransport_cost(ll_i).SurchargeInfo(ll_checked_ind).DCS_quantity = 1
        End If
        
    End If
    
    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Me.Name & ".InitTransportCost()")
End Sub

Private Function GetDCTransportLine(ByVal al_TRANS_Code As Long) As Long
On Error GoTo ErrHandler
    Dim ll_i As Long
    
    For ll_i = LBound(moa_DCTransport_cost) To UBound(moa_DCTransport_cost)
        If moa_DCTransport_cost(ll_i).TRANS_Code = al_TRANS_Code Then
            GetDCTransportLine = ll_i
            Exit For
        End If
    Next

    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetDCTransportLine()")
End Function

Private Function GetTotalQty(ByVal ab_forTransport As Boolean) As Double
On Error GoTo ErrHandler
    Dim ld_TotalQty As Double
    Dim ll_i As Long
    
    ld_TotalQty = 0
    For ll_i = LBound(moa_DCTransport_cost) To UBound(moa_DCTransport_cost)
        If moa_DCTransport_cost(ll_i).IsReturn = (chk_isReturn.Value = vbChecked) Then
            ' calculate qty for transaport/loaded only for the same direction (delivery/return)
            If ab_forTransport Then
                ld_TotalQty = ld_TotalQty + IIf(moa_DCTransport_cost(ll_i).Quantity_loaded = 0, moa_DCTransport_cost(ll_i).Quantity, moa_DCTransport_cost(ll_i).Quantity_loaded)
            Else
                ld_TotalQty = ld_TotalQty + Max(moa_DCTransport_cost(ll_i).Quantity, moa_DCTransport_cost(ll_i).Quantity_loaded)
            End If
        End If
    Next

    GetTotalQty = ld_TotalQty
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetTotalQty()")
End Function

Private Function Max(ByVal ad_val1 As Double, ByVal ad_val2 As Double) As Double
On Error GoTo ErrHandler

    Max = IIf(ad_val1 > ad_val2, ad_val1, ad_val2)

    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".Max()")
End Function

Private Function GetCurrentQty(ByVal ab_forTransport As Boolean) As Double
On Error GoTo ErrHandler
    
    Dim ld_orderQty As Double
    Dim ld_realQty As Double
    
    If txt_QuantityWeight.Text <> "" And IsNumericValue(txt_QuantityWeight.Text) Then
        ld_orderQty = Val(txt_QuantityWeight.Text)
    Else
        ld_orderQty = 0
    End If
    
    If txt_RealQuantity.Text <> "" And IsNumericValue(txt_RealQuantity.Text) Then
        ld_realQty = Val(txt_RealQuantity.Text)
    Else
        ld_realQty = 0
    End If
    
    If ab_forTransport Then
        GetCurrentQty = IIf(ld_realQty = 0, ld_orderQty, ld_realQty)
    Else
        GetCurrentQty = Max(ld_orderQty, ld_realQty)
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetCurrentQty()")
End Function

Private Function GetTranQty(ByVal al_Idx As Long, ByVal ab_forTransport As Boolean) As Double
On Error GoTo ErrHandler
    
    Dim ld_orderQty As Double
    Dim ld_realQty As Double
    
    ld_orderQty = moa_DCTransport_cost(al_Idx).Quantity
    
    ld_realQty = moa_DCTransport_cost(al_Idx).Quantity_loaded
    
    If ab_forTransport Then
        GetTranQty = IIf(ld_realQty = 0, ld_orderQty, ld_realQty)
    Else
        GetTranQty = Max(ld_orderQty, ld_realQty)
    End If
    
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetTranQty()")
End Function


Private Function GetMostExpensiveTransportLine() As Long
On Error GoTo ErrHandler
    Dim ll_expensiveTransport As Long
    
    Dim ll_i As Long
    
    Dim ld_mostExpensiveCost As Double
    Dim ld_currentCost As Double
    
    Debug.Assert (UBound(moa_DCTransport_cost) >= 0)
    
    ll_expensiveTransport = 0
    ld_mostExpensiveCost = GetPriceFullTruck(moa_DCTransport_cost(0), moa_DCTransport_cost(0).DCPLL_Full_Truck_Min)
    
    For ll_i = LBound(moa_DCTransport_cost) + 1 To UBound(moa_DCTransport_cost)
    
        ld_currentCost = GetPriceFullTruck(moa_DCTransport_cost(ll_i), moa_DCTransport_cost(ll_i).DCPLL_Full_Truck_Min)
        
        If ld_currentCost > ld_mostExpensiveCost Then
            
            ll_expensiveTransport = ll_i
            ld_mostExpensiveCost = ld_currentCost
            
        ElseIf ld_currentCost = ld_mostExpensiveCost Then
            If GetTranQty(ll_i, QTY_FOR_COST) > GetTranQty(ll_expensiveTransport, QTY_FOR_COST) Then
                ll_expensiveTransport = ll_i
            End If
        End If
    Next

    GetMostExpensiveTransportLine = ll_expensiveTransport
    Exit Function
ErrHandler:
    Call ErrorHandler(Me.Name & ".GetMostExpensiveTransportLine()")
End Function

Private Sub CheckTransportCost(ByVal as_dropOffCost As Double, ByVal as_FullTruckCalculation As String, ByRef ab_isFullTruck As Boolean, ByRef ab_overLoaded As Boolean, ByRef ab_overLoadedCost As Boolean, ByRef ab_mixedUOM As Boolean, ByRef ab_isFullTruckCost As Boolean, ByRef ab_isTrailer As Boolean)
On Error GoTo ErrHandler
    
    Debug.Assert (UBound(moa_DCTransport_cost) >= 0)
    
    ab_isFullTruck = False
    ab_overLoaded = False
    ab_overLoadedCost = False
    ab_mixedUOM = False
    ab_isFullTruckCost = False
    ab_isTrailer = False
    
    Dim ls_UOM_Code As String
    ls_UOM_Code = moa_DCTransport_cost(LBound(moa_DCTransport_cost)).UOM_Code
    
    
    Dim ll_mostExpensiveLine As Long
    ll_mostExpensiveLine = GetMostExpensiveTransportLine()

    Dim ll_i As Long
    
    For ll_i = LBound(moa_DCTransport_cost) + 1 To UBound(moa_DCTransport_cost)
     
        If ls_UOM_Code <> moa_DCTransport_cost(ll_i).UOM_Code Then
            ab_mixedUOM = True
        End If
    
    Next
    
    
    Dim ld_QtyTotalCost As Double
    ld_QtyTotalCost = GetTotalQty(QTY_FOR_COST)
    
    If moa_DCTransport_cost(ll_mostExpensiveLine).DCPL_Code <> 0 Then
        ' if we have some cost -> we calculate overloaded truck
    
        Dim ld_QtyTotal As Double
        ld_QtyTotal = GetTotalQty(QTY_FOR_TRANSPORT)
        
        If ld_QtyTotal >= moa_DCTransport_cost(ll_mostExpensiveLine).DCPLL_Full_Truck_Min Then
            
            If ld_QtyTotal <= moa_DCTransport_cost(ll_mostExpensiveLine).DCPLL_Full_Truck_Max Then
                ab_isFullTruck = True
                If moa_DCTransport_cost(ll_mostExpensiveLine).DCPLL_Trailer_min > 0 And _
                    ld_QtyTotal >= moa_DCTransport_cost(ll_mostExpensiveLine).DCPLL_Trailer_min _
                Then
                    ab_isTrailer = True
                End If
            Else
                'overloaded
                ab_overLoaded = True
            End If
            
        End If
        
        If ld_QtyTotalCost > moa_DCTransport_cost(ll_mostExpensiveLine).DCPLL_Full_Truck_Max Then
            ab_overLoadedCost = True
        End If
        
    End If

    If as_FullTruckCalculation = "N" Then
        ' if the drop off cost is zero then we count each delivery
        If as_dropOffCost = 0 Then
            ab_isFullTruckCost = False
        ElseIf UBound(moa_DCTransport_cost) <> LBound(moa_DCTransport_cost) Then
            ' if there is some dropoff and more than 1 transaction we count as full truck
            ab_isFullTruckCost = True
        End If
    Else
        ' calculate from real qty
        If ld_QtyTotalCost >= moa_DCTransport_cost(ll_mostExpensiveLine).DCPLL_Full_Truck_Min Then
            ab_isFullTruckCost = True
        End If
    End If

    Exit Sub
ErrHandler:
    Call ErrorHandler(Me.Name & ".CheckTransportCost()")
End Sub


Private Sub txt_QuantityWeight_Validate(Cancel As Boolean)
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    
    If Not CheckNumericValue(txt_QuantityWeight.Text) Then
        Cancel = True
        txt_QuantityWeight.SelStart = 0
        txt_QuantityWeight.SelLength = Len(txt_QuantityWeight.Text)
        Exit Sub
    End If
    
    Dim ll_Index As Long
    ll_Index = GetDCTransportLine(ml_d)
    
    Dim ld_newQty As Double
    
    If CheckNumericValue(txt_QuantityWeight.Text) And Trim(txt_QuantityWeight.Text) <> "" Then
        
        ld_newQty = Val(txt_QuantityWeight.Text)
    
    Else
    
        ld_newQty = 0
    
    End If
    
    If moa_DCTransport_cost(ll_Index).Quantity = ld_newQty Then
        Exit Sub
    End If
    
    moa_DCTransport_cost(ll_Index).Quantity = ld_newQty
    
    If mb_synchLoadedQty Then
        
        txt_RealQuantity.Text = txt_QuantityWeight.Text
        moa_DCTransport_cost(ll_Index).Quantity_loaded = ld_newQty
    
    End If
    
    Cancel = Not GenerateTransportCost
    
    If Not Cancel Then
    
        Call GenerateSurchargeCost
    
        Call UpdateTotalCost
        
    End If
    
    ' update palletes if UOM is PAL
    If GetCboKey(cbo_UOM) = "PAL" Then
        txt_palletes.Text = txt_QuantityWeight.Text
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Me.Name & ".txt_QuantityWeight_Validate()")
End Sub

Private Sub txt_RealQuantity_Validate(Cancel As Boolean)
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub

    If Not CheckNumericValue(txt_RealQuantity.Text) Then
        Cancel = True
        txt_RealQuantity.SelStart = 0
        txt_RealQuantity.SelLength = Len(txt_RealQuantity.Text)
        Exit Sub
    End If
    
    Dim ll_Index As Long
    ll_Index = GetDCTransportLine(ml_d)
    
    Dim ld_newQty As Double
    
    If CheckNumericValue(txt_RealQuantity.Text) And Trim(txt_RealQuantity.Text) <> "" Then
        
        ld_newQty = Val(txt_RealQuantity.Text)
    
    Else
    
        ld_newQty = 0
    
    End If
    
    If moa_DCTransport_cost(ll_Index).Quantity_loaded = ld_newQty Then
        Exit Sub
    End If
    
    moa_DCTransport_cost(ll_Index).Quantity_loaded = ld_newQty
    
    Cancel = Not GenerateTransportCost

    If Not Cancel Then
    
        Call GenerateSurchargeCost
    
        Call UpdateTotalCost
    End If
    
        ' update palletes if UOM is PAL
    If GetCboKey(cbo_UOM) = "PAL" Then
        txt_palletes.Text = txt_RealQuantity.Text
    End If

    Exit Sub
ErrHandler:
    Call ErrorMessage(Me.Name & ".txt_RealQuantity_Validate()")
End Sub

Private Sub cbo_UOM_ComboItemSelected()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub

    Dim ll_Index As Long
    ll_Index = GetDCTransportLine(ml_d)
    
    Dim ll_newDCPL_Code As Long
    
    ll_newDCPL_Code = Val(GetCboValue(cbo_UOM, "DCPL_Code"))
    
    If moa_DCTransport_cost(ll_Index).DCPL_Code = ll_newDCPL_Code And ll_newDCPL_Code <> 0 Then
        Exit Sub
    End If
    
    moa_DCTransport_cost(ll_Index).DCPL_Code = ll_newDCPL_Code
    moa_DCTransport_cost(ll_Index).UOM_Code = GetCboKey(cbo_UOM)

    Call GenerateTransportCost
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost
    
    ' update palletes if UOM is PAL
    If GetCboKey(cbo_UOM) = "PAL" Then
        txt_palletes.Text = txt_QuantityWeight.Text
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Me.Name & ".cbo_UOM_ComboItemSelected()")
End Sub


Private Sub cbo_postCode_Click()
On Error GoTo ErrHandler
    If mb_eventRunning Then Exit Sub
    
    mb_eventRunning = True
    
    cbo_postCode.Tag = cbo_postCode.Text

    Call RefreshSurchargeInfo(True)
    
    Call GenerateTransportCost
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost
    
    mb_eventRunning = False
    
    Exit Sub
ErrHandler:
    mb_eventRunning = False
    Call ErrorMessage(Me.Name & ".cbo_postCode_Change()")
End Sub

Private Sub cbo_postCode_GotFocus()
On Error GoTo ErrHandler
    
    cbo_postCode.Tag = cbo_postCode.Text

    Exit Sub
ErrHandler:
    Call ErrorMessage(Me.Name & ".cbo_postCode_GotFocus()")
End Sub

Private Sub cbo_postCode_LostFocus()
On Error GoTo ErrHandler
    
    If cbo_postCode.Tag = cbo_postCode.Text Then Exit Sub
    
    Call GenerateTransportCost
    
    Call GenerateSurchargeCost
    
    Call UpdateTotalCost
    
    Exit Sub
ErrHandler:
    Call ErrorMessage(Me.Name & ".cbo_postCode_LostFocus()")
End Sub


Private Sub UpdateSAPData(ByVal as_orderNo As String)
On Error GoTo ErrHandler

    Dim ls_retContent As String
    Dim ls_retHeader As String
    Dim lo_XMLParam     As New SvcXMLParam
    
    If Not mo_Sys.CallWebservice(ms_UrlWebService, C_SAP_LOGIN, C_SAP_PASSW, "as_order_No=" & as_orderNo, "application/x-www-form-urlencoded", "", ls_retContent, ls_retHeader) Then
        ' no service
        Call MsgBox("SAP sales document service call failed with error: No service (" & ms_UrlWebService & ")")
        Exit Sub
    End If
    
    If Not lo_XMLParam.CheckHTTPResponse(ls_retHeader) Then
        ' no 200 response
        Call MsgBox("SAP sales document service return with HTTP error.")
        Exit Sub
    End If
    
    If Not lo_XMLParam.TestContentType(ls_retHeader, "text/xml") Then
        ' unexpected return type
        Call MsgBox("SAP sales document service call failed with error: Unexpected content type")
        Exit Sub
    End If
    
    If Not mo_sapXML.loadXML(ls_retContent) Then
        Call MsgBox("SAP sales order service call failed with error: Error in reading XML")
        Exit Sub
    End If
    
    ' display sales order data data
        
    Dim lo_XMLItem As MSXML2.IXMLDOMNode
    Dim lo_XMLItems As MSXML2.IXMLDOMNodeList
    
    ' check if there is an error message
    Set lo_XMLItems = mo_sapXML.selectNodes("/Result/clientMsg")
    If lo_XMLItems.length > 0 Then
        For Each lo_XMLItem In lo_XMLItems
            Call MsgBox(lo_XMLItem.Text)
        Next
        Exit Sub
    End If
    
    Set lo_XMLItems = mo_sapXML.selectNodes("/DataSet/inforow")
    
    Dim ls_delivNb As String
    Dim ls_delivItem As String
    
    Call cbo_delivery.Clear
    For Each lo_XMLItem In lo_XMLItems
        If Val(lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "DELIV_NUMB")) <> 0 Then
            cbo_delivery.AddItem (Val(lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "DELIV_NUMB")) & "/" & Val(lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "DELIV_ITEM")))
            ls_delivNb = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "DELIV_NUMB")
            ls_delivItem = lo_XMLParam.GetXMLNodeValue(lo_XMLItem, "DELIV_ITEM")
        End If
    Next
    
    Call SearchSAPData(ls_delivNb, ls_delivItem)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Me.Name & ".UpdateSAPData()")
End Sub


Private Function BeginTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    BeginTran = False
    
    If ms_inTranName <> "" Then
        MsgBox ("Already in transaction!!!!! " & ms_inTranName)
        Exit Function
    End If
    
    ExecuteSQLSafe mo_Db, "BEGIN TRANSACTION " & as_Tran
    
    ms_inTranName = as_Tran

    BeginTran = True
    Exit Function
    
ErrHandler:
    'try to log error
'    Call LogMessage("BeginTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".BeginTran, your application will be close. Please contact your IT support", , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End
End Function

Private Function CommitTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    CommitTran = False
    
    If ms_inTranName <> as_Tran Then
        Call MsgBox("Warning!!! Commit transaction name does not match!!! " & as_Tran & "<>" & ms_inTranName, vbCritical)
    End If
    
    ExecuteSQLSafe mo_Db, "COMMIT TRANSACTION " & as_Tran

    ms_inTranName = ""
    CommitTran = True
    Exit Function
    
ErrHandler:
    'try to log error
'    Call LogMessage("CommitTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".CommitTran, your application will be close. Please contact your IT support", , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End

End Function

Private Function RollbackTran(as_Tran As String) As Boolean
    
    Dim ll_errNumber As Long, ls_ErrSource As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSource = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    RollbackTran = False
    
    If ms_inTranName <> as_Tran Then
        Call MsgBox("Warning!!! Rollback transaction name does not match!!! " & as_Tran & "<>" & ms_inTranName, vbCritical)
    End If
    
    ExecuteSQLSafe mo_Db, "ROLLBACK TRANSACTION " & as_Tran
    ms_inTranName = ""


    Err.Number = ll_errNumber
    Err.Source = ls_ErrSource
    Err.Description = ls_ErrDesc

    RollbackTran = True
    Exit Function
    
ErrHandler:
    'try to log error
'    Call LogMessage("RollbackTran: " & as_Tran)
    Call mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".RollbackTran, your application will be close. Please contact your IT support", , App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision
    End
End Function

Private Sub SetTextBoxFocus(ByRef ao_tb As TextBox)
On Error GoTo ErrHandler
    
    ao_tb.SelStart = 0
    ao_tb.SelLength = Len(ao_tb.Text)
    Call ao_tb.SetFocus

    Exit Sub
ErrHandler:
    Call ErrorHandler(Me.Name & ".SetTextBoxFocus")
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate Me.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        Me.Refresh
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

Private Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String
On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = Replace(DB_REQ, "$id$", aID, , , vbTextCompare)
    lRequest = Replace(lRequest, "$lang$", aLang, , , vbTextCompare)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_idx As Integer
    If Not IsMissing(aInfo) Then
        For li_idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_idx, 0), aInfo(li_idx, 1), , , vbTextCompare)
        Next li_idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call MsgBox("Connection failure accessing message information.")
    MsgText = aDefault
End Function

Private Function GetSurchargePrice(ByRef ao_priceData As tDCSurcharge_cost, ByVal ad_tansportCost As Double) As Double
On Error GoTo ErrHandler
    
    Call VBScriptReset
    
    Call mo_scriptObj.AddCode("Price=" & Replace(ao_priceData.DCS_Price, DecimalSeparator, ".") & vbCrLf & "Quantity=" & Replace(ao_priceData.DCS_quantity, DecimalSeparator, ".") & vbCrLf & "Cost=" & Replace(ad_tansportCost, DecimalSeparator, "."))
    
    GetSurchargePrice = mo_scriptObj.Eval(ao_priceData.SurchargeFormula)
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetSurchargePrice code:" & "Price=" & Replace(ao_priceData.DCS_Price, DecimalSeparator, ".") & vbCrLf & "Quantity=" & Replace(ao_priceData.DCS_quantity, DecimalSeparator, ".") & vbCrLf & ao_priceData.SurchargeFormula)
End Function

Private Function GetPrice(ByRef ao_priceData As tDCTransport_cost) As Double
On Error GoTo ErrHandler
    
    Call VBScriptReset
    
    Call mo_scriptObj.AddCode("Price=" & Replace(ao_priceData.DCPLLI_Price, DecimalSeparator, ".") & vbCrLf & "Quantity=" & Replace(Max(ao_priceData.Quantity, ao_priceData.Quantity_loaded), DecimalSeparator, "."))
    
    GetPrice = mo_scriptObj.Eval(ao_priceData.PriceFormula)
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetPrice code:" & "Price=" & Replace(ao_priceData.DCPLLI_Price, DecimalSeparator, ".") & vbCrLf & "Quantity=" & Replace(Max(ao_priceData.Quantity, ao_priceData.Quantity_loaded), DecimalSeparator, ".") & vbCrLf & ao_priceData.FullTruckPriceFormula)
End Function

Private Function GetPriceFullTruck(ByRef ao_priceData As tDCTransport_cost, ByVal ad_Qty As Double) As Double
On Error GoTo ErrHandler

    Call VBScriptReset
    
    Call mo_scriptObj.AddCode("Price=" & Replace(ao_priceData.DCPLL_Full_Truck_Price, DecimalSeparator, ".") & vbCrLf & "Quantity=" & Replace(ad_Qty, DecimalSeparator, "."))
    
    GetPriceFullTruck = mo_scriptObj.Eval(ao_priceData.FullTruckPriceFormula)
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("GetPriceFullTruck code:" & "Price=" & Replace(ao_priceData.DCPLL_Full_Truck_Price, DecimalSeparator, ".") & vbCrLf & "Quantity=" & Replace(ad_Qty, DecimalSeparator, ".") & vbCrLf & ao_priceData.FullTruckPriceFormula)
End Function

Private Sub VBScriptReset()

On Error GoTo ErrHandler

    Call mo_scriptObj.Reset
    
    Call mo_scriptObj.AddCode("Function IIf(bClause, sTrue, sFalse) " & vbCrLf & _
                              "If CBool(bClause) Then " & vbCrLf & _
                              "IIf = sTrue " & vbCrLf & _
                              "    Else " & vbCrLf & _
                              "IIf = sFalse " & vbCrLf & _
                              "End If " & vbCrLf & _
                              "End Function")
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("VBScriptReset")
End Sub

Private Sub UpdatePriceTrailer_tran(ByRef ao_priceData As tDCTransport_cost, ByVal ad_Qty As Double)
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC DC_Transaction_sel $TRANS_Code$"

    Dim ll_Cursor  As Long
    ll_Cursor = OpenSQLSafe(mo_Db, Replace(C_REQ, "$TRANS_Code$", SQLNum(ao_priceData.TRANS_Code), , , vbTextCompare))
    
    If Not mo_Db.EOF(ll_Cursor) Then
    
        Call UpdatePriceTrailer(ao_priceData, ad_Qty, mo_Db.GetFields(ll_Cursor, "Ship_To_CT_Code"), mo_Db.GetFields(ll_Cursor, "Ship_To_Zip_Code"))
    
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Sub
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler("UpdatePriceTrailer_tran")
End Sub


Private Sub UpdatePriceTrailer(ByRef ao_priceData As tDCTransport_cost, ByVal ad_Qty As Double, ByVal as_CT_Code As String, ByVal as_zip_code As String)
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC DC_PriceListPriceTrailer_sel $DCPL_Code$, $Ship_To_CT_Code$, $Ship_To_Zip_Code$, $Quantity_for_cost$"

    Dim ls_req As String
    ls_req = Replace(C_REQ, "$DCPL_Code$", SQLNum(ao_priceData.DCPL_Code), , , vbTextCompare)
    ls_req = Replace(ls_req, "$Quantity_for_cost$", SQLNum(ad_Qty), , vbTextCompare)
    ls_req = Replace(ls_req, "$Ship_To_CT_Code$", SqlStr(as_CT_Code, 4, True), , vbTextCompare)
    ls_req = Replace(ls_req, "$Ship_To_Zip_Code$", SqlStr(Trim(as_zip_code), 20, True), , vbTextCompare)
    
    Dim ll_Cursor  As Long
    ll_Cursor = OpenSQLSafe(mo_Db, ls_req)
    
    If Not mo_Db.EOF(ll_Cursor) Then
        
        ao_priceData.DCPLLI_code = mo_Db.GetFields(ll_Cursor, "DCPLLI_Code")
        ao_priceData.DCPLL_Full_Truck_Price = mo_Db.GetFields(ll_Cursor, "DCPLLI_Price")
        ao_priceData.FullTruckPriceFormula = mo_Db.GetFields(ll_Cursor, "PriceFormula")

    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Sub
    
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    
    Call ErrorHandler("UpdatePriceTrailer")
End Sub
